/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.math.BigDecimal;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackIn;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MField;
import org.compiere.model.X_AD_Field;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FieldElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        StringBuffer sqlB;
        String include_tabname = element.attributes.getValue("ADIncludeTabNameID");
        if (element.defer && element.recordId > 0 && include_tabname != null) {
            MField field = new MField(ctx, element.recordId, this.getTrxName(ctx));
            this.setIncluded_Tab_ID(ctx, field, include_tabname);
            field.saveEx();
            return;
        }
        PackIn packIn = (PackIn)ctx.get("PackInProcess");
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.getElementValue().equals("tab") && element.parent.defer) {
            element.defer = true;
            return;
        }
        String name = atts.getValue("Name");
        String tabname = atts.getValue("ADTabNameID");
        String colname = atts.getValue("ADColumnNameID");
        String tableName = atts.getValue("ADTableNameID");
        int tableid = packIn.getTableId(tableName);
        if (tableid <= 0 && (tableid = this.get_IDWithColumn(ctx, "AD_Table", "TableName", tableName)) > 0) {
            packIn.addTable(tableName, tableid);
        }
        if (tableid <= 0) {
            element.defer = true;
            return;
        }
        int windowid = this.get_ID(ctx, "AD_Window", atts.getValue("ADWindowNameID"));
        if (windowid <= 0) {
            element.defer = true;
            return;
        }
        int columnid = packIn.getColumnId(tableName, colname);
        if (columnid <= 0 && (columnid = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", colname, "AD_Table", tableid)) > 0) {
            packIn.addColumn(tableName, colname, columnid);
        }
        if (columnid <= 0) {
            element.defer = true;
            return;
        }
        int tabid = 0;
        if (element.parent != null && element.parent.getElementValue().equals("tab") && element.parent.recordId > 0) {
            tabid = element.parent.recordId;
        } else {
            sqlB = new StringBuffer("select AD_Tab_ID from AD_Tab where AD_Window_ID = " + windowid).append(" and Name = '" + tabname + "'").append(" and AD_Table_ID = ?");
            tabid = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), tableid);
            if (element.parent != null && element.parent.getElementValue().equals("tab") && tabid > 0) {
                element.parent.recordId = tabid;
            }
        }
        if (tabid <= 0) {
            element.defer = true;
            return;
        }
        sqlB = new StringBuffer("select AD_Field_ID from AD_Field where AD_Column_ID = ").append(columnid).append(" and AD_Tab_ID = ?");
        int id = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), tabid);
        MField m_Field = new MField(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_Field_ID") != null && Integer.parseInt(atts.getValue("AD_Field_ID")) <= 999999) {
            m_Field.setAD_Field_ID(Integer.parseInt(atts.getValue("AD_Field_ID")));
        }
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Field", m_Field);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_Field.setName(atts.getValue("Name"));
        m_Field.setAD_Column_ID(columnid);
        name = atts.getValue("ADFieldGroupNameID");
        id = this.get_IDWithColumn(ctx, "AD_FieldGroup", "Name", name);
        m_Field.setAD_FieldGroup_ID(id);
        m_Field.setAD_Tab_ID(tabid);
        m_Field.setEntityType(atts.getValue("EntityType"));
        m_Field.setIsSameLine(Boolean.valueOf(atts.getValue("SameLine")));
        m_Field.setIsCentrallyMaintained(Boolean.valueOf(atts.getValue("isCentrallyMaintained")));
        m_Field.setIsDisplayed(Boolean.valueOf(atts.getValue("Displayed")));
        m_Field.setIsFieldOnly(Boolean.valueOf(atts.getValue("isFieldOnly")));
        m_Field.setIsHeading(Boolean.valueOf(atts.getValue("isHeading")));
        m_Field.setIsReadOnly(Boolean.valueOf(atts.getValue("isReadOnly")));
        m_Field.setSeqNo(Integer.parseInt(atts.getValue("SeqNo")));
        m_Field.setDisplayLength(Integer.parseInt(atts.getValue("DisplayLength")));
        m_Field.setDescription(this.getStringValue(atts, "Description"));
        m_Field.setHelp(this.getStringValue(atts, "Help"));
        m_Field.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        String sortNo = this.getStringValue(atts, "SortNo");
        if (sortNo != null) {
            m_Field.setSortNo(new BigDecimal(sortNo));
        }
        m_Field.setDisplayLogic(this.getStringValue(atts, "DisplayLogic"));
        String Name = atts.getValue("ADReferenceNameID");
        id = this.get_IDWithColumn(ctx, "AD_Reference", "Name", Name);
        m_Field.setAD_Reference_ID(id);
        Name = atts.getValue("ADValRuleNameID");
        id = this.get_IDWithColumn(ctx, "AD_Val_Rule", "Name", Name);
        m_Field.setAD_Val_Rule_ID(id);
        Name = atts.getValue("ADReferenceNameValueID");
        id = this.get_IDWithColumn(ctx, "AD_Reference", "Name", Name);
        m_Field.setAD_Reference_Value_ID(id);
        m_Field.setInfoFactoryClass(this.getStringValue(atts, "InfoFactoryClass"));
        this.setIncluded_Tab_ID(ctx, m_Field, include_tabname);
        if (m_Field.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Field.getName(), "Field", m_Field.get_ID(), AD_Backup_ID, Object_Status, "AD_Field", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Field"));
            element.recordId = m_Field.getAD_Field_ID();
            if (m_Field.getAD_Field_ID() <= 0) return;
            if (include_tabname == null) return;
            if (m_Field.getIncluded_Tab_ID() > 0) return;
            element.defer = true;
            return;
        }
        this.record_log(ctx, 0, m_Field.getName(), "Field", m_Field.get_ID(), AD_Backup_ID, Object_Status, "AD_Field", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Field"));
        throw new POSaveFailedException("Failed to save field definition.");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_Field_ID = Env.getContextAsInt(ctx, "AD_Field_ID");
        X_AD_Field m_Field = new X_AD_Field(ctx, AD_Field_ID, null);
        AttributesImpl atts = new AttributesImpl();
        this.createFieldBinding(atts, m_Field);
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        if (m_Field.getAD_FieldGroup_ID() > 0) {
            packOut.createFieldGroupElement(m_Field.getAD_FieldGroup_ID(), document);
        }
        if (m_Field.getAD_Reference_ID() > 0) {
            packOut.createReference(m_Field.getAD_Reference_ID(), document);
        }
        if (m_Field.getAD_Reference_Value_ID() > 0) {
            packOut.createReference(m_Field.getAD_Reference_Value_ID(), document);
        }
        if (m_Field.getAD_Val_Rule_ID() > 0) {
            packOut.createDynamicRuleValidation(m_Field.getAD_Val_Rule_ID(), document);
        }
        document.startElement("", "", "field", atts);
        document.endElement("", "", "field");
    }

    private AttributesImpl createFieldBinding(AttributesImpl atts, X_AD_Field m_Field) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_Field.getAD_Field_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Field_ID", "CDATA", Integer.toString(m_Field.getAD_Field_ID()));
        }
        if (m_Field.getAD_Column_ID() > 0) {
            sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getAD_Column_ID());
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", "");
        }
        if (m_Field.getAD_Column_ID() > 0) {
            sql = "SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?";
            int idTable = DB.getSQLValue(null, sql, m_Field.getAD_Column_ID());
            sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
            name = DB.getSQLValueString(null, sql, idTable);
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADTableNameID", "CDATA", "");
        }
        if (m_Field.getAD_FieldGroup_ID() > 0) {
            sql = "SELECT Name FROM AD_FieldGroup WHERE AD_FieldGroup_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getAD_FieldGroup_ID());
            atts.addAttribute("", "", "ADFieldGroupNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADFieldGroupNameID", "CDATA", "");
        }
        if (m_Field.getAD_Field_ID() > 0) {
            sql = "SELECT Name FROM AD_Field WHERE AD_Field_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getAD_Field_ID());
            atts.addAttribute("", "", "ADFieldNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADFieldNameID", "CDATA", "");
        }
        if (m_Field.getAD_Tab_ID() > 0) {
            sql = "SELECT Name FROM AD_Tab WHERE AD_Tab_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getAD_Tab_ID());
            atts.addAttribute("", "", "ADTabNameID", "CDATA", name);
            sql = "SELECT AD_Window_ID FROM AD_Tab WHERE AD_Tab_ID=?";
            int windowid = DB.getSQLValue(null, sql, m_Field.getAD_Tab_ID());
            sql = "SELECT Name FROM AD_Window WHERE AD_Window_ID=?";
            name = DB.getSQLValueString(null, sql, windowid);
            atts.addAttribute("", "", "ADWindowNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADTabNameID", "CDATA", "");
        }
        if (m_Field.getIncluded_Tab_ID() > 0) {
            sql = "SELECT Name FROM AD_Tab WHERE AD_Tab_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getIncluded_Tab_ID());
            atts.addAttribute("", "", "ADIncludeTabNameID", "CDATA", name);
        }
        atts.addAttribute("", "", "EntityType", "CDATA", m_Field.getEntityType() != null ? m_Field.getEntityType() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_Field.getName() != null ? m_Field.getName() : "");
        atts.addAttribute("", "", "SameLine", "CDATA", m_Field.isSameLine() ? "true" : "false");
        atts.addAttribute("", "", "isCentrallyMaintained", "CDATA", m_Field.isCentrallyMaintained() ? "true" : "false");
        atts.addAttribute("", "", "Displayed", "CDATA", m_Field.isDisplayed() ? "true" : "false");
        atts.addAttribute("", "", "isActive", "CDATA", m_Field.isActive() ? "true" : "false");
        atts.addAttribute("", "", "isEncrypted", "CDATA", m_Field.isEncrypted() ? "true" : "false");
        atts.addAttribute("", "", "isFieldOnly", "CDATA", m_Field.isFieldOnly() ? "true" : "false");
        atts.addAttribute("", "", "isHeading", "CDATA", m_Field.isHeading() ? "true" : "false");
        atts.addAttribute("", "", "isReadOnly", "CDATA", m_Field.isReadOnly() ? "true" : "false");
        atts.addAttribute("", "", "SeqNo", "CDATA", "" + m_Field.getSeqNo());
        atts.addAttribute("", "", "DisplayLength", "CDATA", m_Field.getDisplayLength() > 0 ? "" + m_Field.getDisplayLength() : "0");
        atts.addAttribute("", "", "Description", "CDATA", m_Field.getDescription() != null ? m_Field.getDescription() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_Field.getHelp() != null ? m_Field.getHelp() : "");
        atts.addAttribute("", "", "SortNo", "CDATA", m_Field.getSortNo() != null ? m_Field.getSortNo().toString() : "");
        atts.addAttribute("", "", "DisplayLogic", "CDATA", m_Field.getDisplayLogic() != null ? m_Field.getDisplayLogic() : "");
        atts.addAttribute("", "", "ObscureType", "CDATA", m_Field.getObscureType() != null ? m_Field.getObscureType() : "");
        atts.addAttribute("", "", "InfoFactoryClass", "CDATA", m_Field.getInfoFactoryClass() != null ? m_Field.getInfoFactoryClass() : "");
        if (m_Field.getAD_Reference_ID() > 0) {
            sql = "SELECT Name FROM AD_Reference WHERE AD_Reference_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getAD_Reference_ID());
            atts.addAttribute("", "", "ADReferenceNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADReferenceNameID", "CDATA", "");
        }
        if (m_Field.getAD_Reference_Value_ID() > 0) {
            sql = "SELECT Name FROM AD_Reference WHERE AD_Reference_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getAD_Reference_Value_ID());
            atts.addAttribute("", "", "ADReferenceNameValueID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADReferenceNameValueID", "CDATA", "");
        }
        if (m_Field.getAD_Val_Rule_ID() > 0) {
            sql = "SELECT Name FROM AD_Val_Rule WHERE AD_Val_Rule_ID=?";
            name = DB.getSQLValueString(null, sql, m_Field.getAD_Val_Rule_ID());
            atts.addAttribute("", "", "ADValRuleNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADValRuleNameID", "CDATA", "");
        }
        return atts;
    }

    private void setIncluded_Tab_ID(Properties ctx, MField field, String includedTabName) {
        if (includedTabName == null) {
            return;
        }
        String trxName = this.getTrxName(ctx);
        int AD_Tab_ID = field.getAD_Tab_ID();
        if (AD_Tab_ID <= 0) {
            this.log.warning("AD_Tab_ID=0 (" + field + ")");
            return;
        }
        int AD_Window_ID = DB.getSQLValueEx(trxName, "SELECT AD_Window_ID FROM AD_Tab WHERE AD_Tab_ID=?", AD_Tab_ID);
        int included_Tab_ID = DB.getSQLValueEx(trxName, "SELECT AD_Tab_ID FROM AD_Tab WHERE Name=? AND AD_Window_ID=? AND AD_Tab_ID<>?", includedTabName, AD_Window_ID, AD_Tab_ID);
        if (included_Tab_ID > 0) {
            field.setIncluded_Tab_ID(included_Tab_ID);
        }
    }
}

