/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.IDFinder;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DataElementHandler
extends AbstractElementHandler {
    private PO genericPO = null;
    int AD_Backup_ID = -1;
    String objectStatus = null;
    String d_tablename = null;
    private DataRowElementHandler rowHandler = new DataRowElementHandler();
    private DataColumnElementHandler columnHandler = new DataColumnElementHandler();

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        if (elementValue.equals("adempieredata") || elementValue.equals("data")) {
            this.log.info(elementValue);
            if (atts.getValue("clientname") != null) {
                int AD_Client_ID = IDFinder.get_ID("AD_Client", atts.getValue("clientname"), this.getClientId(ctx), this.getTrxName(ctx));
                Env.setContext(ctx, "AD_Client_ID", AD_Client_ID);
                this.log.info("adempieredata: client set to " + AD_Client_ID + " " + atts.getValue("clientname"));
            }
        } else if (elementValue.equals("dtable")) {
            this.log.info(elementValue + " " + atts.getValue("name"));
            this.d_tablename = atts.getValue("name");
        } else if (elementValue.equals("drow")) {
            this.rowHandler.startElement(ctx, element);
        } else if (elementValue.equals("dcolumn")) {
            this.columnHandler.startElement(ctx, element);
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        if (elementValue.equals("drow")) {
            this.rowHandler.endElement(ctx, element);
        }
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        String sql = Env.getContext(ctx, "SQLStatement");
        int table_id = Env.getContextAsInt(ctx, "AD_Table_ID");
        Statement stmt = DB.createStatement();
        AttributesImpl atts = new AttributesImpl();
        document.startElement("", "", "data", atts);
        try {
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData meta = rs.getMetaData();
            int columns = meta.getColumnCount();
            int i = 1;
            String col_Name = null;
            String sql1 = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
            String table_Name = DB.getSQLValueString(null, sql1, table_id);
            atts.clear();
            atts.addAttribute("", "", "name", "CDATA", table_Name);
            document.startElement("", "", "dtable", atts);
            while (rs.next()) {
                String sql2;
                atts.clear();
                int key1 = 0;
                String nameatts = "";
                for (i = 1; i <= columns; ++i) {
                    String cName;
                    col_Name = meta.getColumnName(i).toUpperCase();
                    if (col_Name.equals("NAME") && rs.getObject("name") != null) {
                        nameatts = "" + rs.getObject("name");
                    }
                    if ((cName = DB.getSQLValueString(null, sql2 = "SELECT ColumnName FROM AD_Column WHERE isKey = 'Y' AND AD_Table_ID = ? AND Upper(ColumnName)= '" + col_Name + "'", table_id)) == null) continue;
                    if (cName.toUpperCase().equals(col_Name) && key1 == 0) {
                        atts.addAttribute("", "", "key1name", "CDATA", cName);
                        atts.addAttribute("", "", "lookupkey1name", "CDATA", "" + rs.getObject(col_Name));
                        key1 = 1;
                        continue;
                    }
                    if (!cName.toUpperCase().equals(col_Name) || key1 != true) continue;
                    atts.addAttribute("", "", "key2name", "CDATA", cName);
                    atts.addAttribute("", "", "lookupkey2name", "CDATA", "" + rs.getObject(col_Name));
                    key1 = 2;
                }
                atts.addAttribute("", "", "name", "CDATA", nameatts);
                if (key1 == 0) {
                    atts.addAttribute("", "", "key1name", "CDATA", "");
                    atts.addAttribute("", "", "lookupkey1name", "CDATA", "");
                    key1 = 1;
                }
                if (key1 == 1) {
                    atts.addAttribute("", "", "key2name", "CDATA", "");
                    atts.addAttribute("", "", "lookupkey2name", "CDATA", "");
                }
                document.startElement("", "", "drow", atts);
                for (i = 1; i <= columns; ++i) {
                    atts.clear();
                    col_Name = meta.getColumnName(i).toUpperCase();
                    sql2 = "Select A.ColumnName, B.Name From AD_Column A, AD_Reference B Where Upper(A.columnname) = ? and A.AD_TABLE_ID = ? and A.AD_Reference_ID = B.AD_Reference_ID";
                    CPreparedStatement pstmt = null;
                    try {
                        pstmt = DB.prepareStatement(sql2, this.getTrxName(ctx));
                        pstmt.setString(1, col_Name);
                        pstmt.setInt(2, table_id);
                        ResultSet rs1 = pstmt.executeQuery();
                        while (rs1.next()) {
                            atts.clear();
                            atts.addAttribute("", "", "name", "CDATA", rs1.getString("ColumnName"));
                            atts.addAttribute("", "", "class", "CDATA", rs1.getString("Name"));
                            if (rs1.getString("Name").equals("Date") || rs1.getString("Name").equals("Date+Time") || rs1.getString("Name").equals("Time")) {
                                atts.addAttribute("", "", "value", "CDATA", "" + rs.getTimestamp(i));
                            } else {
                                atts.addAttribute("", "", "value", "CDATA", "" + rs.getObject(i));
                            }
                            if (rs1.getString("ColumnName").equals("Created") || rs1.getString("ColumnName").equals("CreatedBy") || rs1.getString("ColumnName").equals("Updated") || rs1.getString("ColumnName").equals("UpdatedBy")) continue;
                            document.startElement("", "", "dcolumn", atts);
                            document.endElement("", "", "dcolumn");
                        }
                        rs1.close();
                        pstmt.close();
                        pstmt = null;
                        continue;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "getData", e);
                    }
                }
                document.endElement("", "", "drow");
            }
            rs.close();
            stmt.close();
            stmt = null;
            document.endElement("", "", "dtable");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getData", e);
        }
        document.endElement("", "", "data");
    }

    class DataColumnElementHandler
    extends AbstractElementHandler {
        DataColumnElementHandler() {
        }

        @Override
        public void startElement(Properties ctx, Element element) throws SAXException {
            String elementValue = element.getElementValue();
            Attributes atts = element.attributes;
            this.log.info(elementValue + " " + atts.getValue("name"));
            String columnName = atts.getValue("name");
            int tableid = this.get_IDWithColumn(ctx, "AD_Table", "TableName", DataElementHandler.this.d_tablename);
            int id = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", columnName, "AD_Table", tableid);
            StringBuffer sql = new StringBuffer("SELECT IsUpdateable FROM AD_column WHERE AD_Column_ID = ?");
            String isUpdateable = DB.getSQLValueString(this.getTrxName(ctx), sql.toString(), id);
            sql = new StringBuffer("SELECT IsKey FROM AD_column WHERE AD_Column_ID = ?");
            String isKey = DB.getSQLValueString(this.getTrxName(ctx), sql.toString(), id);
            if ("New".equals(DataElementHandler.this.objectStatus) || isKey.equals("N") && isUpdateable.equals("Y") && (!atts.getValue("name").equals("CreatedBy") || !atts.getValue("name").equals("UpdatedBy"))) {
                if (atts.getValue("value") != null && !atts.getValue("value").equals("null")) {
                    if (atts.getValue("class").equals("String") || atts.getValue("class").equals("Text") || atts.getValue("class").equals("List") || atts.getValue("class").equals("Yes-No") || atts.getValue("class").equals("Button") || atts.getValue("class").equals("Memo") || atts.getValue("class").equals("Text Long") || atts.getValue("name").equals("AD_Language") || atts.getValue("name").equals("EntityType")) {
                        DataElementHandler.this.genericPO.set_ValueOfColumn(atts.getValue("name").toString(), (Object)atts.getValue("value").toString());
                    } else if (atts.getValue("class").equals("Number") || atts.getValue("class").equals("Amount") || atts.getValue("class").equals("Quantity") || atts.getValue("class").equals("Costs+Prices")) {
                        DataElementHandler.this.genericPO.set_ValueOfColumn(atts.getValue("name").toString(), (Object)new BigDecimal(atts.getValue("value")));
                    } else if (atts.getValue("class").equals("Integer") || atts.getValue("class").equals("ID") || atts.getValue("class").equals("Table Direct") || atts.getValue("class").equals("Table") || atts.getValue("class").equals("Location (Address)") || atts.getValue("class").equals("Account") || atts.getValue("class").equals("Color)") || atts.getValue("class").equals("Search") || atts.getValue("class").equals("Locator (WH)") || atts.getValue("class").equals("Product Attribute")) {
                        DataElementHandler.this.genericPO.set_ValueOfColumn(atts.getValue("name").toString(), (Object)Integer.valueOf(atts.getValue("value")));
                    } else if (atts.getValue("class").equals("Boolean")) {
                        DataElementHandler.this.genericPO.set_ValueOfColumn(atts.getValue("name"), (Object)new Boolean(atts.getValue("value").equals("true")));
                    } else if (atts.getValue("class").equals("Date") || atts.getValue("class").equals("Date+Time") || atts.getValue("class").equals("Time")) {
                        DataElementHandler.this.genericPO.set_ValueOfColumn(atts.getValue("name").toString(), (Object)Timestamp.valueOf(atts.getValue("value")));
                    }
                } else if (atts.getValue("lookupname") != null && !"".equals(atts.getValue("lookupname"))) {
                    String m_tablename = atts.getValue("name").substring(0, atts.getValue("name").length() - 3);
                    DataElementHandler.this.genericPO.set_ValueOfColumn(atts.getValue("name"), (Object)new Integer(this.getIDbyName(ctx, m_tablename, atts.getValue("lookupname"))));
                } else if (atts.getValue("lookupvalue") != null && !"".equals(atts.getValue("lookupvalue"))) {
                    String m_tablename = atts.getValue("name").substring(0, atts.getValue("name").length() - 3);
                    DataElementHandler.this.genericPO.set_ValueOfColumn(atts.getValue("name"), (Object)new Integer(this.getIDbyValue(ctx, m_tablename, atts.getValue("lookupvalue"))));
                }
            }
        }

        @Override
        public void endElement(Properties ctx, Element element) throws SAXException {
        }

        @Override
        public void create(Properties ctx, TransformerHandler document) throws SAXException {
        }
    }

    class DataRowElementHandler
    extends AbstractElementHandler {
        DataRowElementHandler() {
        }

        @Override
        public void startElement(Properties ctx, Element element) throws SAXException {
            String elementValue = element.getElementValue();
            Attributes atts = element.attributes;
            this.log.info(elementValue + " " + atts.getValue("name"));
            MTable table = MTable.get(ctx, DataElementHandler.this.d_tablename);
            String d_rowname = atts.getValue("name");
            if (!d_rowname.equals("")) {
                int id = this.get_ID(ctx, DataElementHandler.this.d_tablename, d_rowname);
                DataElementHandler.this.genericPO = table.getPO(id, this.getTrxName(ctx));
                if (id > 0) {
                    if (DataElementHandler.this.genericPO == null || DataElementHandler.this.genericPO.get_ID() != id) {
                        throw new SAXException("id not found");
                    }
                    DataElementHandler.this.AD_Backup_ID = this.copyRecord(ctx, DataElementHandler.this.d_tablename, DataElementHandler.this.genericPO);
                    DataElementHandler.this.objectStatus = "Update";
                } else {
                    DataElementHandler.this.objectStatus = "New";
                    DataElementHandler.this.AD_Backup_ID = 0;
                }
            } else {
                String sql = "select * from " + DataElementHandler.this.d_tablename;
                String whereand = " where";
                String CURRENT_KEY = "key1name";
                if (atts.getValue(CURRENT_KEY) != null && !atts.getValue(CURRENT_KEY).equals("")) {
                    sql = sql + whereand + " " + atts.getValue(CURRENT_KEY) + "=" + atts.getValue("lookup" + CURRENT_KEY);
                    whereand = " and";
                }
                if (atts.getValue(CURRENT_KEY = "key2name") != null && !atts.getValue(CURRENT_KEY).equals("")) {
                    sql = sql + whereand + " " + atts.getValue(CURRENT_KEY) + "=" + atts.getValue("lookup" + CURRENT_KEY);
                    whereand = " and";
                }
                if (whereand.equals(" where")) {
                    this.log.warning("no name or keyXname attribute defined.");
                }
                try {
                    CPreparedStatement pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        DataElementHandler.this.objectStatus = "Update";
                        DataElementHandler.this.genericPO = table.getPO(rs, this.getTrxName(ctx));
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                    } else {
                        String valueObject;
                        String colName;
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        DataElementHandler.this.objectStatus = "New";
                        DataElementHandler.this.genericPO = table.getPO(0, this.getTrxName(ctx));
                        CURRENT_KEY = "key1name";
                        if (!atts.getValue(CURRENT_KEY).equals("")) {
                            colName = atts.getValue(CURRENT_KEY);
                            valueObject = atts.getValue("lookup" + CURRENT_KEY);
                            if (colName.endsWith("_ID") && valueObject.contains("SELECT")) {
                                valueObject = DB.getSQLValueString(this.getTrxName(ctx), valueObject, new Object[0]);
                            }
                            DataElementHandler.this.genericPO.set_ValueOfColumn(colName, (Object)valueObject);
                        }
                        if (!atts.getValue(CURRENT_KEY = "key2name").equals("")) {
                            colName = atts.getValue(CURRENT_KEY);
                            valueObject = atts.getValue("lookup" + CURRENT_KEY);
                            if (colName.endsWith("_ID") && valueObject.contains("SELECT")) {
                                valueObject = DB.getSQLValueString(this.getTrxName(ctx), valueObject, new Object[0]);
                            }
                            DataElementHandler.this.genericPO.set_ValueOfColumn(colName, (Object)valueObject);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.warning("keyXname attribute. init from rs error." + e);
                    throw new SAXException(e.getMessage());
                }
            }
            if (this.getClientId(ctx) > 0 && DataElementHandler.this.genericPO.getAD_Client_ID() != this.getClientId(ctx)) {
                DataElementHandler.this.genericPO.set_ValueOfColumn("AD_Client_ID", (Object)this.getClientId(ctx));
            }
            if (!d_rowname.equals("") && (Integer)DataElementHandler.this.genericPO.get_Value(DataElementHandler.this.d_tablename + "_ID") == 0) {
                this.log.info("new genericPO, table: " + DataElementHandler.this.d_tablename + " name:" + d_rowname);
                DataElementHandler.this.genericPO.set_ValueOfColumn("Name", (Object)d_rowname);
                HashMap defaults = new HashMap();
                HashMap thisDefault = (HashMap)defaults.get(DataElementHandler.this.d_tablename);
                if (thisDefault != null) {
                    Iterator iter = thisDefault.values().iterator();
                    ArrayList thisValue = null;
                    while (iter.hasNext()) {
                        thisValue = (ArrayList)iter.next();
                        if (((String)thisValue.get(2)).equals("String")) {
                            DataElementHandler.this.genericPO.set_ValueOfColumn((String)thisValue.get(0), (Object)((String)thisValue.get(1)));
                            continue;
                        }
                        if (((String)thisValue.get(2)).equals("Integer")) {
                            DataElementHandler.this.genericPO.set_ValueOfColumn((String)thisValue.get(0), (Object)Integer.valueOf((String)thisValue.get(1)));
                            continue;
                        }
                        if (!((String)thisValue.get(2)).equals("Boolean")) continue;
                        DataElementHandler.this.genericPO.set_ValueOfColumn((String)thisValue.get(0), (Object)new Boolean(((String)thisValue.get(1)).equals("true")));
                    }
                }
            }
        }

        @Override
        public void endElement(Properties ctx, Element element) throws SAXException {
            if (DataElementHandler.this.genericPO != null) {
                if (!DataElementHandler.this.genericPO.save(this.getTrxName(ctx))) {
                    this.record_log(ctx, 0, DataElementHandler.this.genericPO.get_TableName(), "Data", DataElementHandler.this.genericPO.get_ID(), DataElementHandler.this.AD_Backup_ID, DataElementHandler.this.objectStatus, DataElementHandler.this.d_tablename, this.get_IDWithColumn(ctx, "AD_Table", "TableName", DataElementHandler.this.d_tablename));
                    throw new POSaveFailedException("GenericPO");
                }
                this.record_log(ctx, 1, DataElementHandler.this.genericPO.get_TableName(), "Data", DataElementHandler.this.genericPO.get_ID(), DataElementHandler.this.AD_Backup_ID, DataElementHandler.this.objectStatus, DataElementHandler.this.d_tablename, this.get_IDWithColumn(ctx, "AD_Table", "TableName", DataElementHandler.this.d_tablename));
                DataElementHandler.this.genericPO = null;
            }
        }

        @Override
        public void create(Properties ctx, TransformerHandler document) throws SAXException {
        }
    }
}

