/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.adempiere.apps.graph.Graph;
import org.adempiere.apps.graph.GraphColumn;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MQuery;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class HtmlDashboard
extends JPanel
implements MouseListener,
ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 8125801717324723271L;
    private static Dimension paneldimensionMin = new Dimension(80, 80);
    private JEditorPane html;
    private static CLogger log = CLogger.getCLogger(HtmlDashboard.class);
    MGoal[] m_goals = null;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mRefresh = new CMenuItem(Msg.getMsg(Env.getCtx(), "Refresh"), Env.getImageIcon("Refresh16.gif"));
    URL lastUrl = null;
    ArrayList<MQuery> queryZoom = null;

    public HtmlDashboard(String url, MGoal[] m_goals, boolean scrolling) {
        this.setName("test title");
        this.setLayout(new BorderLayout());
        this.m_goals = m_goals;
        JEditorPane.registerEditorKitForContentType("text/html", "org.adempiere.apps.graph.FCHtmlEditorKit");
        this.html = new JEditorPane();
        this.html.setContentType("text/html");
        this.html.setEditable(false);
        this.htmlUpdate(url);
        JScrollPane scrollPane = null;
        scrollPane = scrolling ? new JScrollPane() : new JScrollPane(21, 31);
        scrollPane.getViewport().add((Component)this.html, "Center");
        this.add((Component)scrollPane, "Center");
        this.setMinimumSize(paneldimensionMin);
        this.addMouseListener(this);
        this.html.addHyperlinkListener(this);
        this.mRefresh.addActionListener(this);
        this.popupMenu.add(this.mRefresh);
        this.html.addMouseListener(this);
        this.html.setBackground(this.getBackground());
    }

    public HtmlDashboard(String url) {
        new HtmlDashboard(url, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHTML(PAGE_TYPE requestPage) {
        String result = "<html><head>";
        URL url = this.getClass().getClassLoader().getResource("org/compiere/images/PAPanel.css");
        try {
            String cssLine;
            InputStreamReader ins = new InputStreamReader(url.openStream());
            BufferedReader bufferedReader = new BufferedReader(ins);
            result = result + "<style type=\"text/css\">";
            while ((cssLine = bufferedReader.readLine()) != null) {
                result = result + cssLine + "\n";
            }
            result = result + "</style>";
        }
        catch (IOException e1) {
            log.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
        switch (requestPage) {
            case PAGE_LOGO: {
                result = result + "</head><body class=\"header\"><table width=\"100%\"><tr><td><img src=\"res:org/compiere/images/logo_ad.png\"></td><td></td><td width=\"290\"></td></tr></table></body></html>";
                break;
            }
            case PAGE_HOME: {
                result = result + "</head><body><div class=\"content\">\n";
                this.queryZoom = null;
                this.queryZoom = new ArrayList();
                String appendToHome = null;
                String sql = " SELECT x.AD_CLIENT_ID, x.NAME, x.DESCRIPTION, x.AD_WINDOW_ID, x.PA_GOAL_ID, x.LINE, x.HTML, m.AD_MENU_ID FROM PA_DASHBOARDCONTENT x LEFT OUTER JOIN AD_MENU m ON x.ad_window_id=m.ad_window_id WHERE (x.AD_Client_ID=0 OR x.AD_Client_ID=?) AND x.IsActive='Y' AND x.ZulFilePath IS NULL ORDER BY LINE";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, Env.getAD_Client_ID(Env.getCtx()));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        appendToHome = rs.getString("HTML");
                        if (appendToHome != null) {
                            if (rs.getString("DESCRIPTION") != null) {
                                result = result + "<H2>" + rs.getString("DESCRIPTION") + "</H2>\n";
                            }
                            result = result + this.stripHtml(appendToHome, false) + "<br>\n";
                        }
                        if (rs.getInt("AD_MENU_ID") > 0) {
                            result = result + "<a class=\"hrefNode\" href=\"http:///window/node#" + String.valueOf(rs.getInt("AD_WINDOW_ID") + "\">" + rs.getString("DESCRIPTION") + "</a><br>\n");
                        }
                        result = result + "<br>\n";
                        if (rs.getInt("PA_GOAL_ID") <= 0) continue;
                        result = result + this.goalsDetail(rs.getInt("PA_GOAL_ID"));
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                }
                finally {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                result = result + "<br><br><br>\n</div>\n</body>\n</html>\n";
                break;
            }
            default: {
                log.warning("Unknown option - " + (Object)((Object)requestPage));
            }
        }
        return result;
    }

    private String goalsDetail(int AD_Table_ID) {
        String output = "";
        if (this.m_goals == null) {
            return output;
        }
        for (int i = 0; i < this.m_goals.length; ++i) {
            MMeasureCalc mc = MMeasureCalc.get(Env.getCtx(), this.m_goals[i].getMeasure().getPA_MeasureCalc_ID());
            if (AD_Table_ID != this.m_goals[i].getPA_Goal_ID()) continue;
            output = output + "<table class=\"dataGrid\"><tr>\n<th colspan=\"3\" class=\"label\"><b>" + this.m_goals[i].getName() + "</b></th></tr>\n";
            output = output + "<tr><td class=\"label\">Target</td><td colspan=\"2\" class=\"tdcontent\">" + this.m_goals[i].getMeasureTarget() + "</td></tr>\n";
            output = output + "<tr><td class=\"label\">Actual</td><td colspan=\"2\" class=\"tdcontent\">" + this.m_goals[i].getMeasureActual() + "</td></tr>\n";
            Graph barPanel = new Graph(this.m_goals[i]);
            GraphColumn[] bList = barPanel.getGraphColumnList();
            MQuery query = null;
            output = output + "<tr><td rowspan=\"" + bList.length + "\" class=\"label\" valign=\"top\">" + this.m_goals[i].getXAxisText() + "</td>\n";
            for (int k = 0; k < bList.length; ++k) {
                GraphColumn bgc = bList[k];
                if (k > 0) {
                    output = output + "<tr>";
                }
                if (bgc.getAchievement() != null) {
                    MAchievement a = bgc.getAchievement();
                    query = MQuery.getEqualQuery("PA_Measure_ID", a.getPA_Measure_ID());
                } else if (bgc.getGoal() != null) {
                    MGoal goal = bgc.getGoal();
                    query = MQuery.getEqualQuery("PA_Measure_ID", goal.getPA_Measure_ID());
                } else if (bgc.getMeasureCalc() != null) {
                    mc = bgc.getMeasureCalc();
                    query = mc.getQuery(this.m_goals[i].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), MRole.getDefault());
                } else if (bgc.getProjectType() != null) {
                    MProjectType pt = bgc.getProjectType();
                    query = pt.getQuery(this.m_goals[i].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault());
                } else if (bgc.getRequestType() != null) {
                    MRequestType rt = bgc.getRequestType();
                    query = rt.getQuery(this.m_goals[i].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault());
                }
                output = output + "<td class=\"tdcontent\">" + bgc.getLabel() + "</td><td  class=\"tdcontent\">";
                if (query != null) {
                    output = output + "<a class=\"hrefZoom\" href=\"http:///window/zoom#" + this.queryZoom.size() + "\">" + bgc.getValue() + "</a><br>\n";
                    this.queryZoom.add(query);
                } else {
                    log.info("Nothing to zoom to - " + bgc);
                    output = output + bgc.getValue();
                }
                output = output + "</td></tr>";
            }
            output = output + "</tr><tr><td colspan=\"3\">" + this.m_goals[i].getDescription() + "<br>" + this.stripHtml(this.m_goals[i].getColorSchema().getDescription(), true) + "</td></tr></table>\n";
            bList = null;
            barPanel = null;
        }
        return output;
    }

    private String stripHtml(String htmlString, boolean all) {
        htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
        if (all) {
            htmlString = htmlString.replace(">", "&gt;").replace("<", "&lt;");
        }
        return htmlString;
    }

    private void htmlUpdate(String url) {
        try {
            this.htmlUpdate(new URL(url));
        }
        catch (MalformedURLException e) {
            log.warning("Malformed URL: " + e);
        }
    }

    private void htmlUpdate(URL url) {
        if (url == null || url.getPath().equals("/local/home")) {
            this.html.setText(this.createHTML(PAGE_TYPE.PAGE_HOME));
            this.html.setCaretPosition(0);
            this.lastUrl = url;
        } else if (url.getPath().equals("/local/logo")) {
            this.html.setText(this.createHTML(PAGE_TYPE.PAGE_LOGO));
            this.html.setCaretPosition(0);
            this.lastUrl = url;
        } else if (url.getPath().equals("/local/performance")) {
            this.html.setText(this.createHTML(PAGE_TYPE.PAGE_PERFORMANCE));
        } else if (url.getPath().equals("/window/node")) {
            int AD_Window_ID = Integer.parseInt(url.getRef());
            AWindow frame = new AWindow(this.getGraphicsConfiguration());
            if (!frame.initWindow(AD_Window_ID, null)) {
                return;
            }
            AEnv.addToWindowManager(frame);
            if (Ini.isPropertyBool("OpenWindowMaximized")) {
                AEnv.showMaximized(frame);
            } else {
                AEnv.showCenterScreen(frame);
            }
            frame = null;
            this.html.setCursor(Cursor.getPredefinedCursor(0));
        } else if (url.getPath().equals("/window/zoom")) {
            int index = Integer.parseInt(String.valueOf(url.getRef()));
            if (index >= 0 && index < this.queryZoom.size()) {
                this.html.setCursor(Cursor.getPredefinedCursor(3));
                AEnv.zoom(this.queryZoom.get(index));
                this.html.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (url != null) {
            Cursor cursor = this.html.getCursor();
            this.html.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new PageLoader(this.html, url, cursor));
            this.lastUrl = url;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.htmlUpdate(event.getURL());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mRefresh) {
            if (this.m_goals != null) {
                for (int i = 0; i < this.m_goals.length; ++i) {
                    this.m_goals[i].updateGoal(true);
                }
            }
            this.htmlUpdate(this.lastUrl);
            Container parent = this.getParent();
            if (parent != null) {
                parent.invalidate();
            }
            this.invalidate();
            if (parent != null) {
                parent.repaint();
            } else {
                this.repaint();
            }
        }
    }

    class PageLoader
    implements Runnable {
        private JEditorPane html;
        private URL url;
        private Cursor cursor;

        PageLoader(JEditorPane html, URL url, Cursor cursor) {
            this.html = html;
            this.url = url;
            this.cursor = cursor;
        }

        @Override
        public void run() {
            if (this.url == null) {
                this.html.setCursor(this.cursor);
                Container parent = this.html.getParent();
                parent.repaint();
            } else {
                Document doc = this.html.getDocument();
                try {
                    this.html.setPage(this.url);
                }
                catch (IOException ioe) {
                    this.html.setDocument(doc);
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }

    private static enum PAGE_TYPE {
        PAGE_HOME,
        PAGE_PERFORMANCE,
        PAGE_LOGO;

    }
}

