/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagatePreservingCheckTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagatePreservingUncheckTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagateTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagateUpWhiteTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.SimpleTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeCheckingModel
implements TreeCheckingModel {
    private HashSet<TreePath> checkedPathsSet;
    private HashSet<TreePath> greyedPathsSet;
    private HashSet<TreePath> disabledPathsSet;
    private HashSet<TreePath> checkBoxPathsSet;
    private PropagateCheckingListener propagateCheckingListener;
    protected TreeCheckingMode checkingMode;
    protected TreeModel model;
    protected EventListenerList listenerList = new EventListenerList();

    public DefaultTreeCheckingModel(TreeModel model) {
        this.model = model;
        this.checkedPathsSet = new HashSet();
        this.greyedPathsSet = new HashSet();
        this.disabledPathsSet = new HashSet();
        this.checkBoxPathsSet = new HashSet();
        this.propagateCheckingListener = new PropagateCheckingListener();
        this.setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE);
    }

    @Override
    @Deprecated
    public TreeModelListener getTreeModelListener() {
        return null;
    }

    public void setCheckedPathsSet(HashSet<TreePath> checkedPathsSet) {
        this.checkedPathsSet = checkedPathsSet;
    }

    public void setGreyedPathsSet(HashSet<TreePath> greyedPathsSet) {
        this.greyedPathsSet = greyedPathsSet;
    }

    public void setDisabledPathsSet(HashSet<TreePath> disabledPathsSet) {
        this.disabledPathsSet = disabledPathsSet;
    }

    public void setCheckBoxPathsSet(HashSet<TreePath> checkBoxPathsSet) {
        this.checkBoxPathsSet = checkBoxPathsSet;
    }

    public void updateCheckingConsistency() {
        this.updateSubTreeCheckingConsistency(new TreePath(this.model.getRoot()));
    }

    public void updateSubTreeCheckingConsistency(TreePath path) {
        if (this.isPathGreyed(path)) {
            TreePath[] treePathArray = this.getChildrenPath(path);
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath childPath = treePathArray[n2];
                this.updateSubTreeCheckingConsistency(childPath);
                ++n2;
            }
        } else {
            if (this.isPathChecked(path)) {
                this.checkSubTree(path);
            } else {
                this.uncheckSubTree(path);
            }
            return;
        }
        this.updatePathGreyness(path);
    }

    @Override
    public boolean isPathCheckBox(TreePath path) {
        return this.checkBoxPathsSet.contains(path);
    }

    @Override
    public boolean isPathChecked(TreePath path) {
        return this.checkedPathsSet.contains(path);
    }

    @Override
    public boolean isPathEnabled(TreePath path) {
        return !this.disabledPathsSet.contains(path);
    }

    @Override
    public boolean isPathGreyed(TreePath path) {
        return this.greyedPathsSet.contains(path);
    }

    void addToGreyedPathsSet(TreePath path) {
        this.greyedPathsSet.add(path);
    }

    void removeFromGreyedPathsSet(TreePath path) {
        this.greyedPathsSet.remove(path);
    }

    @Override
    public void setPathEnabled(TreePath path, boolean enable) {
        if (enable) {
            this.disabledPathsSet.remove(path);
        } else {
            this.disabledPathsSet.add(path);
        }
    }

    @Override
    public void setPathsEnabled(TreePath[] paths, boolean enable) {
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            this.setPathEnabled(path, enable);
            ++n2;
        }
    }

    public void addToCheckBoxPathsSet(TreePath path) {
        this.checkBoxPathsSet.add(path);
    }

    void addToCheckedPathsSet(TreePath path) {
        this.checkedPathsSet.add(path);
    }

    void removeFromCheckedPathsSet(TreePath path) {
        this.checkedPathsSet.remove(path);
    }

    public void ungreySubTree(TreePath path) {
        this.removeFromGreyedPathsSet(path);
        TreePath[] treePathArray = this.getChildrenPath(path);
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath childPath = treePathArray[n2];
            this.ungreySubTree(childPath);
            ++n2;
        }
    }

    public void checkSubTree(TreePath path) {
        this.addToCheckedPathsSet(path);
        this.removeFromGreyedPathsSet(path);
        Object node = path.getLastPathComponent();
        int childrenNumber = this.model.getChildCount(node);
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            TreePath childPath = path.pathByAddingChild(this.model.getChild(node, childIndex));
            this.checkSubTree(childPath);
            ++childIndex;
        }
    }

    public void uncheckSubTree(TreePath path) {
        this.removeFromCheckedPathsSet(path);
        this.removeFromGreyedPathsSet(path);
        Object node = path.getLastPathComponent();
        int childrenNumber = this.model.getChildCount(node);
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            TreePath childPath = path.pathByAddingChild(this.model.getChild(node, childIndex));
            this.uncheckSubTree(childPath);
            ++childIndex;
        }
    }

    @Override
    public void toggleCheckingPath(TreePath path) {
        if (!this.isPathEnabled(path)) {
            return;
        }
        if (this.isPathChecked(path)) {
            this.removeCheckingPath(path);
        } else {
            this.addCheckingPath(path);
        }
    }

    @Override
    public void setCheckingPath(TreePath path) {
        this.clearChecking();
        this.addCheckingPath(path);
    }

    @Override
    public void setCheckingPaths(TreePath[] paths) {
        this.clearChecking();
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            this.addCheckingPath(path);
            ++n2;
        }
    }

    @Override
    public void clearChecking() {
        this.checkedPathsSet.clear();
        this.greyedPathsSet.clear();
        this.fireValueChanged(new TreeCheckingEvent(new TreePath(this.model.getRoot())));
    }

    @Override
    public TreePath[] getGreyingPaths() {
        return this.greyedPathsSet.toArray(new TreePath[this.greyedPathsSet.size()]);
    }

    @Override
    public TreePath[] getCheckingPaths() {
        return this.checkedPathsSet.toArray(new TreePath[this.checkedPathsSet.size()]);
    }

    @Override
    public TreePath[] getCheckingRoots() {
        Vector<TreePath> roots = this.getCheckingRoots(new TreePath(this.model.getRoot()));
        return roots.toArray(new TreePath[0]);
    }

    private Vector<TreePath> getCheckingRoots(TreePath path) {
        Object node = path.getLastPathComponent();
        Vector<TreePath> roots = new Vector<TreePath>();
        if (!this.isPathGreyed(path)) {
            if (this.isPathChecked(path)) {
                roots.add(path);
            }
            return roots;
        }
        int childrenNumber = this.model.getChildCount(node);
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            TreePath childPath = path.pathByAddingChild(this.model.getChild(node, childIndex));
            roots.addAll(this.getCheckingRoots(childPath));
            ++childIndex;
        }
        return roots;
    }

    @Override
    public TreeCheckingModel.CheckingMode getCheckingMode() {
        if (this.checkingMode instanceof SimpleTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.SIMPLE;
        }
        if (this.checkingMode instanceof PropagateTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE;
        }
        if (this.checkingMode instanceof PropagatePreservingCheckTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_CHECK;
        }
        if (this.checkingMode instanceof PropagatePreservingUncheckTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_UNCHECK;
        }
        if (this.checkingMode instanceof PropagateUpWhiteTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE_UP_UNCHECK;
        }
        return null;
    }

    @Override
    public void setCheckingMode(TreeCheckingModel.CheckingMode mode) {
        switch (mode) {
            case SIMPLE: {
                this.checkingMode = new SimpleTreeCheckingMode(this);
                break;
            }
            case PROPAGATE: {
                this.checkingMode = new PropagateTreeCheckingMode(this);
                break;
            }
            case PROPAGATE_PRESERVING_CHECK: {
                this.checkingMode = new PropagatePreservingCheckTreeCheckingMode(this);
                break;
            }
            case PROPAGATE_PRESERVING_UNCHECK: {
                this.checkingMode = new PropagatePreservingUncheckTreeCheckingMode(this);
                break;
            }
            case PROPAGATE_UP_UNCHECK: {
                this.checkingMode = new PropagateUpWhiteTreeCheckingMode(this);
                break;
            }
        }
    }

    public void setCheckingMode(TreeCheckingMode mode) {
        this.checkingMode = mode;
    }

    @Override
    public void addCheckingPaths(TreePath[] paths) {
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            this.addCheckingPath(path);
            ++n2;
        }
    }

    @Override
    public void addCheckingPath(TreePath path) {
        this.checkingMode.checkPath(path);
        TreeCheckingEvent event = new TreeCheckingEvent(path);
        this.fireValueChanged(event);
    }

    @Override
    public void removeCheckingPath(TreePath path) {
        this.checkingMode.uncheckPath(path);
        TreeCheckingEvent event = new TreeCheckingEvent(path);
        this.fireValueChanged(event);
    }

    @Override
    public void removeCheckingPaths(TreePath[] paths) {
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            this.removeCheckingPath(path);
            ++n2;
        }
    }

    protected void fireValueChanged(TreeCheckingEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TreeCheckingListener.class) {
                ((TreeCheckingListener)listeners[i + 1]).valueChanged(e);
            }
            i -= 2;
        }
    }

    @Override
    public void addTreeCheckingListener(TreeCheckingListener x) {
        this.listenerList.add(TreeCheckingListener.class, x);
    }

    @Override
    public void removeTreeCheckingListener(TreeCheckingListener x) {
        this.listenerList.remove(TreeCheckingListener.class, x);
    }

    protected void updatePathGreyness(TreePath ancestor) {
        boolean value = this.isPathCheckBox(ancestor);
        Object ancestorNode = ancestor.getLastPathComponent();
        if (!this.isPathCheckBox(ancestor)) {
            this.addToCheckBoxPathsSet(ancestor);
            return;
        }
    }

    public void updateSubTreeGreyness(TreePath path) {
    }

    public void updateTreeGreyness() {
        this.updateSubTreeGreyness(new TreePath(this.model.getRoot()));
    }

    public ChildrenChecking getChildrenChecking(TreePath path) {
        Object node = path.getLastPathComponent();
        int childrenNumber = this.model.getChildCount(node);
        boolean someChecked = false;
        boolean someUnchecked = false;
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            TreePath childPath = path.pathByAddingChild(this.model.getChild(node, childIndex));
            if (this.isPathGreyed(childPath)) {
                return ChildrenChecking.HALF_CHECKED;
            }
            if (this.isPathChecked(childPath)) {
                if (someUnchecked) {
                    return ChildrenChecking.HALF_CHECKED;
                }
                someChecked = true;
            } else {
                if (someChecked) {
                    return ChildrenChecking.HALF_CHECKED;
                }
                someUnchecked = true;
            }
            ++childIndex;
        }
        if (someChecked) {
            return ChildrenChecking.ALL_CHECKED;
        }
        if (someUnchecked) {
            return ChildrenChecking.ALL_UNCHECKED;
        }
        return ChildrenChecking.NO_CHILDREN;
    }

    public boolean pathHasUncheckedChildren(TreePath path) {
        Object node = path.getLastPathComponent();
        int childrenNumber = this.model.getChildCount(node);
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            TreePath childPath = path.pathByAddingChild(this.model.getChild(node, childIndex));
            if (this.isPathGreyed(childPath) | !this.isPathChecked(childPath)) {
                return true;
            }
            ++childIndex;
        }
        return false;
    }

    public boolean pathHasCheckedChildren(TreePath path) {
        return this.pathHasChildrenWithValue(path, true);
    }

    protected boolean pathHasChildrenWithValue(TreePath path, boolean value) {
        TreePath childPath;
        Object node = path.getLastPathComponent();
        int childrenNumber = this.model.getChildCount(node);
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            childPath = path.pathByAddingChild(this.model.getChild(node, childIndex));
            if (this.isPathChecked(childPath) == value) {
                return true;
            }
            ++childIndex;
        }
        childIndex = 0;
        while (childIndex < childrenNumber) {
            childPath = path.pathByAddingChild(this.model.getChild(node, childIndex));
            if (this.pathHasChildrenWithValue(childPath, value)) {
                return true;
            }
            ++childIndex;
        }
        return false;
    }

    public boolean hasDifferentChildren(TreePath path) {
        return this.pathHasChildrenWithValue(path, !this.isPathChecked(path));
    }

    public void updateAncestorsGreyness(TreePath path) {
        TreePath[] parents = new TreePath[path.getPathCount()];
        parents[0] = path;
        boolean greyAll = this.isPathGreyed(path);
        int i = 1;
        while (i < parents.length) {
            parents[i] = parents[i - 1].getParentPath();
            if (greyAll) {
                this.addToGreyedPathsSet(parents[i]);
            } else {
                this.updatePathGreyness(parents[i]);
                greyAll = this.isPathGreyed(parents[i]);
            }
            ++i;
        }
    }

    protected TreePath[] getChildrenPath(TreePath path) {
        Object node = path.getLastPathComponent();
        int childrenNumber = this.model.getChildCount(node);
        TreePath[] childrenPath = new TreePath[childrenNumber];
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            childrenPath[childIndex] = path.pathByAddingChild(this.model.getChild(node, childIndex));
            ++childIndex;
        }
        return childrenPath;
    }

    @Override
    public TreeModel getTreeModel() {
        return this.model;
    }

    @Override
    public void setTreeModel(TreeModel newModel) {
        TreeModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeTreeModelListener(this.propagateCheckingListener);
        }
        this.model = newModel;
        if (newModel != null) {
            newModel.addTreeModelListener(this.propagateCheckingListener);
        }
        this.clearChecking();
    }

    public String toString() {
        return this.toString(new TreePath(this.model.getRoot()));
    }

    private String toString(TreePath path) {
        String checkString = "n";
        String greyString = "n";
        String enableString = "n";
        if (this.isPathChecked(path)) {
            checkString = "y";
        }
        if (this.isPathEnabled(path)) {
            enableString = "y";
        }
        if (this.isPathGreyed(path)) {
            greyString = "y";
        }
        String description = "Path checked: " + checkString + " greyed: " + greyString + " enabled: " + enableString + " Name: " + path.toString() + "\n";
        TreePath[] treePathArray = this.getChildrenPath(path);
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath childPath = treePathArray[n2];
            description = String.valueOf(description) + this.toString(childPath);
            ++n2;
        }
        return description;
    }

    public static enum ChildrenChecking {
        ALL_CHECKED,
        HALF_CHECKED,
        ALL_UNCHECKED,
        NO_CHILDREN;

    }

    private class PropagateCheckingListener
    implements TreeModelListener {
        private PropagateCheckingListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            DefaultTreeCheckingModel.this.checkingMode.updateCheckAfterChildrenInserted(path);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            DefaultTreeCheckingModel.this.checkingMode.updateCheckAfterChildrenRemoved(path);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            DefaultTreeCheckingModel.this.updateSubTreeGreyness(path);
            DefaultTreeCheckingModel.this.updateAncestorsGreyness(path);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            DefaultTreeCheckingModel.this.checkingMode.updateCheckAfterStructureChanged(path);
        }
    }
}

