/*
 * Decompiled with CFR 0.152.
 */
package id.web.sistematika.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MProcessAccess;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MWindow;
import org.compiere.model.MWindowAccess;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class BetaITValidator
implements ModelValidator {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Collection<Integer> listProcess = new ArrayList<Integer>();
    private String betaInfo = "[BetaIT]: ";
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int processCount = 0;

    @Override
    public String docValidate(PO po, int timing) {
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        this.m_AD_Client_ID = client.getAD_Client_ID();
        this.log.config(this.betaInfo + "registering MWindowAccess");
        engine.addModelChange("AD_Window_Access", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        boolean isChange = 5 == type;
        boolean isNew = 4 == type;
        boolean isDelete = 3 == type || 3 == type;
        this.log.info(this.betaInfo + "Start to process model change");
        this.listProcess.clear();
        if (po instanceof MWindowAccess && (isNew || isChange || isDelete)) {
            MTab[] tabs;
            MWindowAccess wAccess = (MWindowAccess)po;
            int windowID = wAccess.getAD_Window_ID();
            MWindow targetWindow = new MWindow(po.getCtx(), windowID, null);
            for (MTab tab : tabs = targetWindow.getTabs(true, null)) {
                MField[] fields;
                if (tab.isAdvancedTab()) continue;
                if (tab.getAD_Process_ID() != 0) {
                    this.listProcess.add(tab.getAD_Process_ID());
                }
                for (MField field : fields = tab.getFields(true, null)) {
                    MColumn column = new MColumn(po.getCtx(), field.getAD_Column_ID(), null);
                    if (column.getAD_Process_ID() == 0) continue;
                    this.listProcess.add(column.getAD_Process_ID());
                }
            }
            int clientId = this.m_AD_Client_ID;
            int roleId = wAccess.getAD_Role_ID();
            MRole targetRole = new MRole(po.getCtx(), roleId, null);
            this.log.info(this.betaInfo + targetWindow.getName() + " window - Is active : " + wAccess.isActive() + " Is deleted : " + isDelete);
            this.processCount = 0;
            if (wAccess.isActive() && !isDelete) {
                for (int i = 0; i <= this.listProcess.size() - 1; ++i) {
                    int processId = (Integer)((ArrayList)this.listProcess).get(i);
                    if (this.checkAvailableProcessAccess(roleId, processId, clientId, po.get_TrxName()) != null) continue;
                    ++this.processCount;
                    MProcessAccess newProcess = new MProcessAccess(po.getCtx(), 0, po.get_TrxName());
                    newProcess.setAD_Org_ID(0);
                    newProcess.setAD_Role_ID(roleId);
                    newProcess.setAD_Process_ID(processId);
                    newProcess.setIsActive(true);
                    newProcess.setIsReadWrite(true);
                    newProcess.save(po.get_TrxName());
                }
                this.log.info(this.betaInfo + targetWindow.getName() + " window - successful registering " + this.processCount + " processes for [" + targetRole.getName() + "] role");
            } else if (!wAccess.isActive() || isDelete) {
                for (int i = 0; i <= this.listProcess.size() - 1; ++i) {
                    int processId = (Integer)((ArrayList)this.listProcess).get(i);
                    String sql = "DELETE FROM ad_process_access WHERE ad_client_id = " + clientId + "AND ad_org_id = 0 AND ad_role_id = " + roleId + "AND ad_process_id = " + processId;
                    int no = DB.executeUpdate(sql, po.get_TrxName());
                    if (no != 1) continue;
                    ++this.processCount;
                }
                this.log.info(this.betaInfo + targetWindow.getName() + " window - successful deleted " + this.processCount + " processes for [" + targetRole.getName() + "] role");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkAvailableProcessAccess(int roleId, int processId, int clientId, String trxName) {
        String testResults = null;
        String sqlProcessAccess = "SELECT 1 FROM ad_process_access WHERE ad_client_id = ? AND ad_org_id = 0 AND ad_role_id = ? AND ad_process_id = ? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sqlProcessAccess, trxName);
            pstmt.setInt(1, clientId);
            pstmt.setInt(2, roleId);
            pstmt.setInt(3, processId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                testResults = "OK";
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sqlProcessAccess, e);
            testResults = e.getLocalizedMessage();
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return testResults;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
        return null;
    }
}

