/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class Process_GetCustStatus
extends SvrProcess {
    private int AD_PInstance_ID = 0;
    private int p_customer_ID = 0;

    protected void prepare() {
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_customer_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        try {
            String sql = "call Beta_CustStatus_proc(?)";
            CallableStatement stmnt = DB.prepareCall((String)sql);
            stmnt.setInt(1, this.p_customer_ID);
            stmnt.execute();
            String bpvalue = "";
            String bpname = "";
            double crlimit = 0.0;
            int crperiod = 0;
            int pdccount = 0;
            double osamt = 0.0;
            double pdcamt = 0.0;
            double uncamt = 0.0;
            double ordamt = 0.0;
            double totsal = 0.0;
            double totpay = 0.0;
            double overdue = 0.0;
            String pterm = "";
            double overduepdc = 0.0;
            String pdcyn = "";
            double avgcrdays = 0.0;
            double lrecamt = 0.0;
            double lyrsalamt = 0.0;
            double lyrrecamt = 0.0;
            CPreparedStatement ps = null;
            ResultSet rs = null;
            String statussql = "select bpvalue, bpname, nvl(crlimit,0), nvl(crperiod,0), nvl(osamt,0), nvl(pdcamt,0), nvl(uncamt,0), nvl(ordamt,0), nvl(pdccount,0), nvl(totsalamt,0),nvl(totpaidamt,0),custopdate,nvl(overdueamt,0),nvl(pterm,'N/A'),nvl(pdcyn,'N'),nvl(overduepdc,0),nvl(avgcrdays,0), last_recdate, last_recamt, last1yr_recamt, last1yr_salamt  from beta_custstatus where c_bpartner_id = ?";
            ps = DB.prepareStatement((String)statussql, (String)"DSPL");
            ps.setInt(1, this.p_customer_ID);
            rs = ps.executeQuery();
            if (rs.next()) {
                bpvalue = rs.getString(1);
                bpname = rs.getString(2);
                crlimit = rs.getBigDecimal(3).doubleValue();
                crperiod = rs.getInt(4);
                osamt = rs.getBigDecimal(5).doubleValue();
                pdcamt = rs.getBigDecimal(6).doubleValue();
                uncamt = rs.getBigDecimal(7).doubleValue();
                ordamt = rs.getBigDecimal(8).doubleValue();
                pdccount = rs.getInt(9);
                totsal = rs.getBigDecimal(10).doubleValue();
                totpay = rs.getBigDecimal(11).doubleValue();
                Date custopdate = rs.getDate(12);
                overdue = rs.getBigDecimal(13).doubleValue();
                pterm = rs.getString(14);
                pdcyn = rs.getString(15);
                overduepdc = rs.getBigDecimal(16).doubleValue();
                avgcrdays = rs.getBigDecimal(17).doubleValue();
                Date recdate = rs.getDate(18);
                lrecamt = rs.getBigDecimal(19).doubleValue();
                lyrrecamt = rs.getBigDecimal(20).doubleValue();
                lyrsalamt = rs.getBigDecimal(21).doubleValue();
                StringBuilder logMessage = new StringBuilder();
                logMessage.append("Customer Current Status").append("\n ===================").append(" \n Customer             : ").append(bpname).append(" \n Credit Limit         : ").append(String.format("%,.2f", crlimit)).append(" \t\t  Payment Term         : ").append(pterm).append("\n").append(" \n Outstanding Amount   : ").append(String.format("%,.2f", osamt)).append(" \n PDC Amount           : ").append(String.format("%,.2f", pdcamt)).append(" \n Uncovered Amount     : ").append(String.format("%,.2f", uncamt)).append(" \n Pending Order Amount : ").append(String.format("%,.2f", ordamt)).append("  \n  O/s + Pend.Ord       : ").append(String.format("%,.2f", osamt + ordamt)).append("\n").append(" \n Over Due Amount      : ").append(String.format("%,.2f", overdue));
                if (pdcyn.equals("Y")) {
                    logMessage.append(" \n Uncollected PDC (Above 45 Days): ").append(String.format("%,.2f", overduepdc));
                }
                logMessage.append("\n \n").append("Customer History").append("\n ===========").append(" \n Customer Op.Date     : ").append(custopdate).append(" \n Total Sales          : ").append(String.format("%,.2f", totsal)).append(" \n    Total Receipt        : ").append(String.format("%,.2f", totpay)).append(" \n Most Recent Receipt: ").append(String.format("%,.2f", lrecamt)).append(" \t On ").append(recdate).append(" \n Last 1 Year Sales      : ").append(String.format("%,.2f", lyrsalamt)).append(" \n Last 1 Year Receipt       : ").append(String.format("%,.2f", lyrrecamt)).append(" \n Avg.Credit Days      : ").append(avgcrdays).append(" \n No.of Bounced PDC    : ").append(pdccount).append("");
                this.addLog(logMessage.toString());
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            String s = e.getLocalizedMessage();
            System.out.println("Error : " + s);
            String[] s1 = s.split(":");
            this.addLog(0, null, null, "Process Stopped");
            this.addLog(0, null, null, s1[1]);
        }
        return "";
    }
}

