/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Order;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class CalloutOrder
extends CalloutEngine {
    private boolean steps = false;

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean newDocNo;
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String oldDocNo = (String)mTab.getValue("DocumentNo");
        boolean bl = newDocNo = oldDocNo == null;
        if (!newDocNo && oldDocNo.startsWith("<") && oldDocNo.endsWith(">")) {
            newDocNo = true;
        }
        Integer oldC_DocType_ID = (Integer)mTab.getValue("C_DocType_ID");
        String sql = "SELECT d.DocSubTypeSO,d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext,s.CurrentNextSys,s.AD_Sequence_ID,d.IsSOTrx, s.StartNewYear, s.DateColumn FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                int AD_Sequence_ID = 0;
                if (!newDocNo && oldC_DocType_ID != 0) {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, oldC_DocType_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Sequence_ID = rs.getInt(7);
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                String DocSubTypeSO = "";
                boolean IsSOTrx = true;
                if (rs.next()) {
                    DocSubTypeSO = rs.getString(1);
                    if (DocSubTypeSO == null) {
                        DocSubTypeSO = "--";
                    }
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"OrderType", (String)DocSubTypeSO);
                    if (!DocSubTypeSO.equals("SO")) {
                        mTab.setValue("IsDropShip", (Object)"N");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("DeliveryRule", (Object)"F");
                    } else if (DocSubTypeSO.equals("PR")) {
                        mTab.setValue("DeliveryRule", (Object)"R");
                    } else {
                        mTab.setValue("DeliveryRule", (Object)"A");
                    }
                    if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("PR") || DocSubTypeSO.equals("WI")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                    } else {
                        mTab.setValue("InvoiceRule", (Object)"D");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        mTab.setValue("PaymentRule", (Object)"P");
                    }
                    if ("N".equals(rs.getString(8))) {
                        IsSOTrx = false;
                    }
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"HasCharges", (String)rs.getString(2));
                    if (rs.getString(4).equals("Y")) {
                        if (!newDocNo && AD_Sequence_ID != rs.getInt(7)) {
                            newDocNo = true;
                        }
                        if (newDocNo) {
                            if (Ini.isPropertyBool((String)"AdempiereSys") && Env.getAD_Client_ID((Properties)Env.getCtx()) < 1000000) {
                                mTab.setValue("DocumentNo", (Object)("<" + rs.getString(6) + ">"));
                            } else if ("Y".equals(rs.getString(9))) {
                                String dateColumn = rs.getString(10);
                                mTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear((GridTab)mTab, (int)rs.getInt(7), (String)dateColumn, null) + ">"));
                            } else {
                                mTab.setValue("DocumentNo", (Object)("<" + rs.getString(5) + ">"));
                            }
                        }
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                if (!DocSubTypeSO.equals("WR") && !DocSubTypeSO.equals("PR")) {
                    sql = "SELECT PaymentRule,C_PaymentTerm_ID,InvoiceRule,DeliveryRule,FreightCostRule,DeliveryViaRule, PaymentRulePO,PO_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?";
                    pstmt = DB.prepareStatement((String)sql, null);
                    int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                        if (s != null && s.length() != 0) {
                            if (IsSOTrx && (s.equals("B") || s.equals("S") || s.equals("U"))) {
                                s = "P";
                            }
                            if (!IsSOTrx && s.equals("B")) {
                                s = "P";
                            }
                            mTab.setValue("PaymentRule", (Object)s);
                        }
                        Integer ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                        if (!rs.wasNull()) {
                            mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                        }
                        if ((s = rs.getString(3)) != null && s.length() != 0) {
                            mTab.setValue("InvoiceRule", (Object)s);
                        }
                        if ((s = rs.getString(4)) != null && s.length() != 0) {
                            mTab.setValue("DeliveryRule", (Object)s);
                        }
                        if ((s = rs.getString(5)) != null && s.length() != 0) {
                            mTab.setValue("FreightCostRule", (Object)s);
                        }
                        if ((s = rs.getString(6)) != null && s.length() != 0) {
                            mTab.setValue("DeliveryViaRule", (Object)s);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,p.DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, lship.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, lbill.C_BPartner_Location_ID AS Bill_Location_ID, p.SOCreditStatus,  p.SalesRep_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx"));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String s;
                    String cont;
                    String loc;
                    Integer salesRep = rs.getInt("SalesRep_ID");
                    if (IsSOTrx && salesRep != 0) {
                        mTab.setValue("SalesRep_ID", (Object)salesRep);
                    }
                    Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("M_PriceList_ID", (Object)ii);
                    } else {
                        int i = Env.getContextAsInt((Properties)ctx, (String)"#M_PriceList_ID");
                        if (i != 0) {
                            mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                        }
                    }
                    mTab.setValue("Bill_BPartner_ID", (Object)C_BPartner_ID);
                    int bill_Location_ID = rs.getInt("Bill_Location_ID");
                    if (bill_Location_ID == 0) {
                        mTab.setValue("Bill_Location_ID", null);
                    } else {
                        mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                    }
                    int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (loc = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_Location_ID")).length() > 0) {
                        shipTo_ID = Integer.parseInt(loc);
                    }
                    if (shipTo_ID == 0) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(shipTo_ID));
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (cont = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    if (contID == 0) {
                        mTab.setValue("AD_User_ID", null);
                    } else {
                        mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                        mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                    }
                    if (IsSOTrx) {
                        double CreditLimit = rs.getDouble("SO_CreditLimit");
                        String SOCreditStatus = rs.getString("SOCreditStatus");
                        if (CreditLimit != 0.0) {
                            double CreditAvailable = rs.getDouble("CreditAvailable");
                            if (!rs.wasNull() && CreditAvailable < 0.0) {
                                mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                            }
                        }
                    }
                    if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                        mTab.setValue("POReference", (Object)s);
                    }
                    if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                        mTab.setValue("Description", (Object)s);
                    }
                    if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                        mTab.setValue("IsDiscountPrinted", (Object)s);
                    } else {
                        mTab.setValue("IsDiscountPrinted", (Object)"N");
                    }
                    String OrderType = Env.getContext((Properties)ctx, (int)WindowNo, (String)"OrderType");
                    mTab.setValue("InvoiceRule", (Object)"D");
                    mTab.setValue("DeliveryRule", (Object)"A");
                    mTab.setValue("PaymentRule", (Object)"P");
                    if (OrderType.equals("PR")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                        mTab.setValue("DeliveryRule", (Object)"R");
                    } else if (OrderType.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                        if (s != null && s.length() != 0) {
                            if (s.equals("B")) {
                                s = "P";
                            }
                            if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                                s = "P";
                            }
                            mTab.setValue("PaymentRule", (Object)s);
                        }
                        ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                        if (!rs.wasNull()) {
                            mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                        }
                        if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                            mTab.setValue("InvoiceRule", (Object)s);
                        }
                        if ((s = rs.getString("DeliveryRule")) != null && s.length() != 0) {
                            mTab.setValue("DeliveryRule", (Object)s);
                        }
                        if ((s = rs.getString("FreightCostRule")) != null && s.length() != 0) {
                            mTab.setValue("FreightCostRule", (Object)s);
                        }
                        if ((s = rs.getString("DeliveryViaRule")) != null && s.length() != 0) {
                            mTab.setValue("DeliveryViaRule", (Object)s);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bPartnerBill(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer bill_BPartner_ID = (Integer)value;
        if (bill_BPartner_ID == null || bill_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,p.DeliveryViaRule,p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,c.AD_User_ID,p.PO_PriceList_ID, p.PaymentRulePO, p.PO_PaymentTerm_ID,lbill.C_BPartner_Location_ID AS Bill_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx"));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, bill_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String s;
                    double CreditLimit;
                    String cont;
                    String loc;
                    Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("M_PriceList_ID", (Object)ii);
                    } else {
                        int i = Env.getContextAsInt((Properties)ctx, (String)"#M_PriceList_ID");
                        if (i != 0) {
                            mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                        }
                    }
                    int bill_Location_ID = rs.getInt("Bill_Location_ID");
                    if (bill_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (loc = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_Location_ID")).length() > 0) {
                        bill_Location_ID = Integer.parseInt(loc);
                    }
                    if (bill_Location_ID == 0) {
                        mTab.setValue("Bill_Location_ID", null);
                    } else {
                        mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (bill_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (cont = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    if (contID == 0) {
                        mTab.setValue("Bill_User_ID", null);
                    } else {
                        mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                    }
                    if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                    if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                        mTab.setValue("POReference", (Object)s);
                    } else {
                        mTab.setValue("POReference", null);
                    }
                    s = rs.getString("SO_Description");
                    if (s != null && s.trim().length() != 0) {
                        mTab.setValue("Description", (Object)s);
                    }
                    if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                        mTab.setValue("IsDiscountPrinted", (Object)s);
                    } else {
                        mTab.setValue("IsDiscountPrinted", (Object)"N");
                    }
                    String OrderType = Env.getContext((Properties)ctx, (int)WindowNo, (String)"OrderType");
                    mTab.setValue("InvoiceRule", (Object)"D");
                    mTab.setValue("PaymentRule", (Object)"P");
                    if (OrderType.equals("PR")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                    } else if (OrderType.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                        if (s != null && s.length() != 0) {
                            if (s.equals("B")) {
                                s = "P";
                            }
                            if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                                s = "P";
                            }
                            mTab.setValue("PaymentRule", (Object)s);
                        }
                        ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                        if (!rs.wasNull()) {
                            mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                        }
                        if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                            mTab.setValue("InvoiceRule", (Object)s);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "bPartnerBill", (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String priceList(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_PriceList_ID = (Integer)mTab.getValue("M_PriceList_ID");
        if (M_PriceList_ID == null || M_PriceList_ID == 0) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT pl.IsTaxIncluded,pl.EnforcePriceLimit,pl.C_Currency_ID,c.StdPrecision,plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, M_PriceList_ID);
                Timestamp date = new Timestamp(System.currentTimeMillis());
                if (mTab.getAD_Table_ID() == I_C_Order.Table_ID) {
                    date = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateOrdered");
                } else if (mTab.getAD_Table_ID() == I_C_Invoice.Table_ID) {
                    date = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateInvoiced");
                }
                pstmt.setTimestamp(2, date);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("IsTaxIncluded", (Object)new Boolean("Y".equals(rs.getString(1))));
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)rs.getString(2));
                    Integer ii = new Integer(rs.getInt(3));
                    mTab.setValue("C_Currency_ID", (Object)ii);
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)rs.getInt(5));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (this.steps) {
            this.log.warning("fini");
        }
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        mTab.setValue("C_Charge_ID", null);
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Product_ID") == M_Product_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyOrdered");
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        MProductPricing pp = new MProductPricing(M_Product_ID.intValue(), C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateOrdered");
        int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)(sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{M_PriceList_ID, orderDate})) > 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        pp.setPriceDate(orderDate);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("Discount", (Object)pp.getDiscount());
        mTab.setValue("C_UOM_ID", (Object)new Integer(pp.getC_UOM_ID()));
        mTab.setValue("QtyOrdered", mTab.getValue("QtyEntered"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)(pp.isEnforcePriceLimit() ? "Y" : "N"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        if (Env.isSOTrx((Properties)ctx, (int)WindowNo)) {
            String WinHdr = Env.getHeader((Properties)ctx, (int)WindowNo);
            WinHdr = WinHdr.substring(0, 3);
            MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
            if (product.isStocked() && WinHdr.equalsIgnoreCase("SAL")) {
                BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
                int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
                int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_AttributeSetInstance_ID");
                BigDecimal available = MStorage.getQtyAvailable((int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, null);
                if (available == null) {
                    available = Env.ZERO;
                }
                if (available.signum() == 0) {
                    System.out.println("NoQtyAvailable");
                } else if (available.compareTo(QtyOrdered) < 0) {
                    System.out.println("InsufficientQtyAvailable");
                } else {
                    BigDecimal total;
                    BigDecimal notReserved;
                    Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                    if (C_OrderLine_ID == null) {
                        C_OrderLine_ID = new Integer(0);
                    }
                    if ((notReserved = MOrderLine.getNotReserved((Properties)ctx, (int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, (int)C_OrderLine_ID)) == null) {
                        notReserved = Env.ZERO;
                    }
                    if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                        String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + available + " - @QtyNotReserved@=" + notReserved + " = " + total));
                        mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                    }
                }
            }
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)new Integer(100));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)"N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Charge_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceLimit", (Object)Env.ZERO);
                    mTab.setValue("PriceList", (Object)Env.ZERO);
                    mTab.setValue("Discount", (Object)Env.ZERO);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Charge_ID");
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = 0;
        shipC_BPartner_Location_ID = column.equals("C_BPartner_Location_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        Timestamp billDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateOrdered");
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DatePromised");
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int billC_BPartner_Location_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"Bill_Location_ID");
        if (billC_BPartner_Location_ID == 0) {
            billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        }
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        int C_Tax_ID = Tax.get((Properties)ctx, (int)M_Product_ID, (int)C_Charge_ID, (Timestamp)billDate, (Timestamp)shipDate, (int)AD_Org_ID, (int)M_Warehouse_ID, (int)billC_BPartner_Location_ID, (int)shipC_BPartner_Location_ID, (boolean)"Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx")));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        boolean enforce;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        boolean IsSO = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsSOTrx"));
        if (IsSO) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        int StdPrecision = MPriceList.getStandardPrecision((Properties)ctx, (int)M_PriceList_ID);
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        this.log.fine("QtyEntered=" + QtyEntered + ", Ordered=" + QtyOrdered + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal Discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        if (M_Product_ID == 0) {
            if (mField.getColumnName().equals("PriceActual")) {
                mTab.setValue("PriceEntered", value);
            } else if (mField.getColumnName().equals("PriceEntered")) {
                mTab.setValue("PriceActual", value);
            }
        } else if ((mField.getColumnName().equals("QtyOrdered") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema"))) {
            int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                QtyOrdered = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered);
            }
            if (QtyOrdered == null) {
                QtyOrdered = QtyEntered;
            }
            boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
            MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, QtyOrdered, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp date = (Timestamp)mTab.getValue("DateOrdered");
            pp.setPriceDate(date);
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            mTab.setValue("PriceActual", (Object)pp.getPriceStd());
            mTab.setValue("Discount", (Object)pp.getDiscount());
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        if (mField.getColumnName().equals("Discount")) {
            if (PriceList.doubleValue() != 0.0) {
                PriceActual = new BigDecimal((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            }
            if (PriceActual.scale() > StdPrecision) {
                PriceActual = PriceActual.setScale(StdPrecision, 4);
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual)) == null) {
                PriceEntered = PriceActual;
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else {
            Discount = PriceList.intValue() == 0 ? Env.ZERO : new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
            if (Discount.scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
        }
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        String epl = Env.getContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit");
        boolean bl = enforce = Env.isSOTrx((Properties)ctx, (int)WindowNo) && epl != null && epl.equals("Y");
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.intValue() != 0) {
                Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                if (Discount.scale() > 2) {
                    Discount = Discount.setScale(2, 4);
                }
                mTab.setValue("Discount", (Object)Discount);
            }
        }
        if ((LineNetAmt = QtyOrdered.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("LineNetAmt=" + LineNetAmt);
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int C_UOM_To_ID;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        if (this.steps) {
            this.log.warning("init - M_Product_ID=" + M_Product_ID + " - ");
        }
        BigDecimal QtyOrdered = Env.ZERO;
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered;
            QtyOrdered = QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyOrdered/PriceEntered=" + QtyOrdered + "/" + PriceEntered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyOrdered")) {
            BigDecimal QtyEntered;
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
            QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get((Properties)ctx, (int)M_Product_ID).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        } else {
            QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        }
        if (M_Product_ID != 0 && Env.isSOTrx((Properties)ctx, (int)WindowNo) && QtyOrdered.signum() > 0) {
            String WinHdr = Env.getHeader((Properties)ctx, (int)WindowNo);
            WinHdr = WinHdr.substring(0, 3);
            MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
            if (product.isStocked() && WinHdr.equalsIgnoreCase("SAL")) {
                int M_AttributeSetInstance_ID;
                int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
                BigDecimal available = MStorage.getQtyAvailable((int)M_Warehouse_ID, (int)M_Product_ID, (int)(M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_AttributeSetInstance_ID")), null);
                if (available == null) {
                    available = Env.ZERO;
                }
                if (available.signum() == 0) {
                    System.out.println("NoQtyAvailable");
                } else if (available.compareTo(QtyOrdered) < 0) {
                    System.out.println("InsufficientQtyAvailable");
                } else {
                    BigDecimal total;
                    BigDecimal notReserved;
                    Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                    if (C_OrderLine_ID == null) {
                        C_OrderLine_ID = new Integer(0);
                    }
                    if ((notReserved = MOrderLine.getNotReserved((Properties)ctx, (int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, (int)C_OrderLine_ID)) == null) {
                        notReserved = Env.ZERO;
                    }
                    if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                        String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + available + "  -  @QtyNotReserved@=" + notReserved + "  =  " + total));
                        mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                    }
                }
            }
        }
        return "";
    }

    /*
     * Loose catch block
     */
    public String BPCheck(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql = null;
        Integer RowNo = null;
        if ((Integer)mTab.getValue("C_BPartner_ID") != null) {
            ResultSet rs;
            CPreparedStatement pstmt;
            block16: {
                block15: {
                    boolean IsSOTrx = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsSOTrx"));
                    sql = IsSOTrx ? "SELECT Value from C_BPartner where IsCustomer='Y' and C_BPartner_ID= ? " : "SELECT Value from C_BPartner where IsVendor='Y' and C_BPartner_ID= ? ";
                    pstmt = null;
                    rs = null;
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, (Integer)mTab.getValue("C_BPartner_ID"));
                    rs = pstmt.executeQuery();
                    rs.next();
                    RowNo = rs.getRow();
                    if (RowNo != 0) break block15;
                    if (IsSOTrx) {
                        mTab.fireDataStatusEEvent("Select Customer", "Please Select a Valid Customer", true);
                    } else {
                        mTab.fireDataStatusEEvent("Select Supplier", "Please Select a Valid Supplier", true);
                    }
                    mTab.setValue("C_BPartner_ID", null);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    try {
                        DB.close((ResultSet)rs, (Statement)pstmt);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return "";
                    catch (Exception exception) {
                        try {
                            DB.close(rs, (Statement)pstmt);
                        }
                        catch (Exception exception2) {}
                        break block16;
                        catch (Throwable throwable) {
                            try {
                                DB.close(rs, (Statement)pstmt);
                            }
                            catch (Exception exception3) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            rs = null;
            pstmt = null;
        }
        return "";
    }

    /*
     * Loose catch block
     */
    public String BPAdd(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        block14: {
            String sql = null;
            Object RowNo = null;
            if (((Integer)mTab.getValue("C_DocTypeTarget_ID") == 1000165 || (Integer)mTab.getValue("C_DocTypeTarget_ID") == 1000364) && (Integer)mTab.getValue("C_BPartner_ID") != null) {
                ResultSet rs;
                CPreparedStatement pstmt;
                block13: {
                    Integer C_BPartner_ID = (Integer)mTab.getValue("C_BPartner_ID");
                    sql = "SELECT name,vat_number from C_BPartner where C_BPartner_ID= ? ";
                    pstmt = null;
                    rs = null;
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block13;
                    mTab.setValue("CUSTNAME", (Object)rs.getString(1));
                    mTab.setValue("VAT_NUMBER", (Object)rs.getString(2));
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    try {
                        DB.close((ResultSet)rs, (Statement)pstmt);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return "";
                    catch (Exception exception) {
                        try {
                            DB.close(rs, (Statement)pstmt);
                        }
                        catch (Exception exception2) {}
                        break block14;
                        catch (Throwable throwable) {
                            try {
                                DB.close(rs, (Statement)pstmt);
                            }
                            catch (Exception exception3) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    public String SetDiscount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql = null;
        Integer RowNo = null;
        BigDecimal Docid = null;
        BigDecimal Disc = null;
        if ((Integer)mTab.getValue("M_Product_ID") != null) {
            ResultSet rs;
            CPreparedStatement pstmt;
            block4: {
                sql = "SELECT C_DOCTYPETARGET_ID,DISCPERC FROM C_ORDER WHERE C_ORDER_ID = ?";
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, (Integer)mTab.getValue("C_ORDER_ID"));
                rs = pstmt.executeQuery();
                rs.next();
                RowNo = rs.getRow();
                if (RowNo != 0) break block4;
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return "";
            }
            try {
                Docid = rs.getBigDecimal("C_DOCTYPETARGET_ID");
                Disc = rs.getBigDecimal("DISCPERC");
            }
            catch (Exception exception) {
                // empty catch block
            }
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            mTab.setValue("LINEDISC", Disc);
        }
        return "";
    }

    public String SetLineDiscPer(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal discPer = Env.ZERO;
        BigDecimal priceList = (BigDecimal)mTab.getValue("PriceList");
        BigDecimal lineNetPrice = (BigDecimal)mTab.getValue("LINENETPRICE");
        BigDecimal discAmt = new BigDecimal(priceList.doubleValue() - lineNetPrice.doubleValue());
        discPer = new BigDecimal(discAmt.doubleValue() * 100.0 / priceList.doubleValue());
        mTab.setValue("Discount", (Object)discPer);
        return "";
    }

    public String SetAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal Discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal Price = (BigDecimal)mTab.getValue("PriceList");
        BigDecimal spDisc = (BigDecimal)mTab.getValue("LINEDISC");
        BigDecimal DiscAmt = new BigDecimal(Price.doubleValue() * Discount.doubleValue() / 100.0);
        BigDecimal ActPrice = new BigDecimal(Price.doubleValue() - DiscAmt.doubleValue());
        BigDecimal spDiscAmt = new BigDecimal(ActPrice.doubleValue() * spDisc.doubleValue() / 100.0);
        BigDecimal netPrice = new BigDecimal(ActPrice.doubleValue() - spDiscAmt.doubleValue());
        mTab.setValue("PriceActual", (Object)netPrice);
        mTab.setValue("PriceEntered", (Object)netPrice);
        mTab.setValue("LINENETPRICE", (Object)ActPrice);
        BigDecimal NetAmt = netPrice.multiply(Qty);
        NetAmt = NetAmt.setScale(2, 4);
        mTab.setValue("LineNetAmt", (Object)NetAmt);
        return "";
    }

    public String SetIsBom(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean IsSO = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsSOTrx"));
        if (IsSO) {
            Integer OrdID = (Integer)mTab.getValue("C_Order_ID");
            String SqlDocType = "Select C_DOCTYPETARGET_ID from c_order where c_order_id = ?";
            BigDecimal DocID = DB.getSQLValueBD(null, (String)SqlDocType, (int)OrdID);
            String SqlSOType = "Select nvl(DOCSUBTYPESO,'SO') from c_doctype where c_doctype_id = ?";
            String SOType = DB.getSQLValueString(null, (String)SqlSOType, (Object[])new Object[]{DocID});
            if (SOType.equalsIgnoreCase("OB")) {
                int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
                try {
                    String sqlIsBom = "Select nvl(ISBOM,'N') from m_product where m_product_id = ?";
                    String strIsBom = DB.getSQLValueString(null, (String)sqlIsBom, (int)M_Product_ID);
                    if (strIsBom.equalsIgnoreCase("Y")) {
                        mTab.setValue("IsBOM", (Object)"Y");
                        mTab.setValue("PriceActual", (Object)Env.ZERO);
                        mTab.setValue("PriceEntered", (Object)Env.ZERO);
                        mTab.setValue("PriceList", (Object)Env.ZERO);
                        mTab.setValue("PriceLimit", (Object)Env.ZERO);
                        mTab.setValue("LineNetAmt", (Object)Env.ZERO);
                    } else {
                        mTab.setValue("IsBOM", (Object)"N");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mTab.setValue("GETPRICE", (Object)"N");
            }
        }
        return "";
    }

    public String SetPriceEditYN(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean IsSO = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsSOTrx"));
        if (IsSO) {
            int prdID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
            int priceID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
            if (prdID > 0 && priceID > 0) {
                BigDecimal versionID = DB.getSQLValueBD(null, (String)"Select max(m_pricelist_version_id) from m_pricelist_version where m_pricelist_id=?", (int)priceID);
                BigDecimal mpPrice = DB.getSQLValueBD(null, (String)"Select nvl(pricelist,0) from m_productprice where m_product_id=? and m_pricelist_version_id=?", (Object[])new Object[]{prdID, versionID});
                if (mpPrice.doubleValue() != 0.0) {
                    mTab.setValue("SETPRICEEDITYN", (Object)"Y");
                } else {
                    mTab.setValue("SETPRICEEDITYN", (Object)"N");
                }
            } else {
                mTab.setValue("SETPRICEEDITYN", (Object)"N");
            }
        } else {
            mTab.setValue("SETPRICEEDITYN", (Object)"N");
        }
        return "";
    }

    public String SetDiscPer(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal discPer = Env.ZERO;
        BigDecimal discAmt = (BigDecimal)mTab.getValue("DISCAMT");
        if (discAmt == null || discAmt.doubleValue() == 0.0) {
            mTab.setValue("DISCPERC", (Object)discPer);
            return "";
        }
        BigDecimal GrAmt = (BigDecimal)mTab.getValue("GRAMT");
        discPer = new BigDecimal(discAmt.doubleValue() * 100.0 / GrAmt.doubleValue());
        mTab.setValue("DISCPERC", (Object)discPer);
        return "";
    }

    public String SetDiscAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal discAmt = Env.ZERO;
        BigDecimal discPer = (BigDecimal)mTab.getValue("DISCPERC");
        if (discPer == null || discPer.doubleValue() == 0.0) {
            mTab.setValue("DISCAMT", (Object)discAmt);
            return "";
        }
        BigDecimal GrAmt = (BigDecimal)mTab.getValue("GRAMT");
        discAmt = new BigDecimal(discPer.doubleValue() * GrAmt.doubleValue() / 100.0);
        discAmt = discAmt.setScale(2, 4);
        mTab.setValue("DISCAMT", (Object)discAmt);
        return "";
    }

    public String GetPrjName(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer ProjId;
        if ((Integer)mTab.getValue("Beta_Cust_Project_ID") != null && (ProjId = (Integer)mTab.getValue("Beta_Cust_Project_ID")).doubleValue() != 1000393.0) {
            String SqlProj = "Select Name from Beta_Cust_Project where Beta_Cust_Project_id = ?";
            String PrjName = DB.getSQLValueString(null, (String)SqlProj, (int)ProjId);
            mTab.setValue("PROJECT", (Object)PrjName);
        }
        return "";
    }
}

