/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CallOutQuotation
extends CalloutEngine {
    public String DiscPer(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || value.equals(Env.ZERO)) {
            return "";
        }
        BigDecimal GrTot = (BigDecimal)mTab.getValue("GrandTotal");
        Double GAmt = new Double("" + GrTot);
        if (GAmt == 0.0) {
            return "";
        }
        BigDecimal DiscPer = (BigDecimal)mTab.getValue("DISCPER");
        BigDecimal taxAmt = (BigDecimal)mTab.getValue("TaxAmt");
        Double DtaxAmt = new Double("" + taxAmt);
        BigDecimal DAmt = GrTot.multiply(DiscPer);
        Double DiscAmt = new Double("" + DAmt);
        DiscAmt = DiscAmt / 100.0;
        Double NetAmt = GAmt - DiscAmt + DtaxAmt;
        BigDecimal da = new BigDecimal(DiscAmt);
        BigDecimal na = new BigDecimal(NetAmt);
        na = na.setScale(2, 4);
        mTab.setValue("DISCAMT", (Object)da);
        mTab.setValue("NETAMT", (Object)na);
        return "";
    }

    public String DiscAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String SqlGrAmt = "Select sum(totalline) from c_quotationline where c_quotation_id = ?";
        Integer quotid = (Integer)mTab.getValue("C_QUOTATION_ID");
        BigDecimal LineTot = DB.getSQLValueBD(null, (String)SqlGrAmt, (int)quotid);
        Double GAmt = new Double("" + LineTot);
        if (GAmt == 0.0) {
            return "";
        }
        BigDecimal DAmt = (BigDecimal)mTab.getValue("DISCAMT");
        Double DiscAmt = new Double("" + DAmt);
        BigDecimal taxAmt = (BigDecimal)mTab.getValue("TaxAmt");
        Double DtaxAmt = new Double("" + taxAmt);
        Double NetAmt = GAmt - DiscAmt + DtaxAmt;
        BigDecimal na = new BigDecimal(NetAmt);
        Double DiscPer = DiscAmt * 100.0 / GAmt;
        BigDecimal dp = new BigDecimal(DiscPer);
        mTab.setValue("DISCPER", (Object)dp);
        BigDecimal ChgAmt = (BigDecimal)mTab.getValue("ChargeAmt");
        Double chgd = new Double("" + ChgAmt);
        Double GrNetAmtd = NetAmt + chgd;
        BigDecimal GrNetAmt = new BigDecimal(GrNetAmtd);
        return "";
    }

    public String GrNet(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal ChgAmt = (BigDecimal)mTab.getValue("ChargeAmt");
        Double chgd = new Double("" + ChgAmt);
        BigDecimal NetAmt = (BigDecimal)mTab.getValue("NETAMT");
        Double netd = new Double("" + NetAmt);
        Double GrNetAmtd = netd + chgd;
        BigDecimal GrNetAmt = new BigDecimal(GrNetAmtd);
        mTab.setValue("GRNETAMT", (Object)GrNetAmt);
        return "";
    }

    public String ProdValid(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql = null;
        Integer RowNo = null;
        if ((Integer)mTab.getValue("M_Product_ID") != null) {
            ResultSet rs;
            CPreparedStatement pstmt;
            block71: {
                sql = "SELECT NVL(DAMPERYN,'N') as DAMPERYN,MANTYPE,NVL(DEFLECTION,'N') as DEFLECTION,NAME,ISBOM,NVL(WAYSYN,'N') as WAYSYN,NVL(CORNERYN,'N') as CORNERYN,NVL(CURVEYN,'N') as CURVEYN,NVL(EQGRID,'N') as EQGRID,NVL(DEFLECTIONYN,'N') as DEFLECTIONYN,NVL(COMBTYPE,'O') as COMBTYPE,VALUE as PRDVAL,NOPARAM,nvl(LENGTH_CELL_ADDR,'N') as LENGTH_CELL_ADDR,nvl(AIRWAY_CELL_ADDR,'N') as AIRWAY_CELL_ADDR,nvl(ISOD,'N') as ISOD,nvl(SUPPLYH_CELL_ADDR,' ') as SUPPLYHCELL,nvl(ALFILTERYN,'N') as ALFILTER,nvl(rmcost,0) as RMCOST,nvl(pricefactor,0) as PF ,nvl(tbaryn,'N') as tbar,nvl(GNA_CELL_ADDR,'A') as GNA,nvl(LVBYAREA,'N') as LVBYAREA,nvl(ISULCLASS,'N') as ISULCLASS,ISVAVMODEL,ISSPCL_YN,ISGASKET_YN from M_Product where M_Product_ID= ? ";
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, (Integer)mTab.getValue("M_Product_ID"));
                rs = pstmt.executeQuery();
                rs.next();
                RowNo = rs.getRow();
                if (RowNo != 0) break block71;
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return "";
            }
            try {
                String Dmp = rs.getString("DAMPERYN");
                String Def = rs.getString("DEFLECTION");
                String Bom = rs.getString("ISBOM");
                String WaysYN = rs.getString("WAYSYN");
                String EQGridYN = rs.getString("EQGRID");
                String DeflectionYN = rs.getString("DEFLECTIONYN");
                String CornerYN = rs.getString("CORNERYN");
                String CurveYN = rs.getString("CURVEYN");
                String CombType = rs.getString("COMBTYPE");
                String PrdVal = rs.getString("PRDVAL");
                String NoParam = rs.getString("NOPARAM");
                String ln = rs.getString("LENGTH_CELL_ADDR");
                String aw = rs.getString("AIRWAY_CELL_ADDR");
                String od = rs.getString("ISOD");
                String supplyhcell = rs.getString("SUPPLYHCELL");
                String alf = rs.getString("ALFILTER");
                BigDecimal rmcost = rs.getBigDecimal("RMCOST");
                BigDecimal pf = rs.getBigDecimal("PF");
                String tBarYN = rs.getString("tbar");
                String gNA = rs.getString("GNA");
                String lvByArea = rs.getString("LVBYAREA");
                String ulClass = rs.getString("ISULCLASS");
                String IsVav = rs.getString("ISVAVMODEL");
                String IsSpcl = rs.getString("ISSPCL_YN");
                String IsGasket = rs.getString("ISGASKET_YN");
                if (Bom.trim().contentEquals("N")) {
                    mTab.setValue("PRODDESC", (Object)rs.getString("NAME"));
                    mTab.setValue("isbom", (Object)"N");
                } else {
                    mTab.setValue("PRODDESC", (Object)"");
                    mTab.setValue("isbom", (Object)"Y");
                }
                if (Bom.trim().contentEquals("Y")) {
                    if (Dmp.trim().contentEquals("Y")) {
                        mTab.setValue("DAMPERYN", (Object)"Y");
                        mTab.setValue("MANTYPE", (Object)rs.getString("MANTYPE"));
                    } else {
                        mTab.setValue("DAMPERYN", (Object)"N");
                        mTab.setValue("MANTYPE", null);
                    }
                }
                if (Def.equalsIgnoreCase("D")) {
                    mTab.setValue("DEFLECTION", (Object)"D");
                } else if (Def.equalsIgnoreCase("S")) {
                    mTab.setValue("DEFLECTION", (Object)"S");
                }
                if (Def.equalsIgnoreCase("D") | Def.equalsIgnoreCase("S")) {
                    String sqlhv = "Select nvl(frontblade,' ') from c_quotation where c_quotation_id = ? ";
                    Integer Qid = (Integer)mTab.getValue("C_QUOTATION_ID");
                    String hv = DB.getSQLValueString(null, (String)sqlhv, (int)Qid);
                    if (hv.equalsIgnoreCase("H") | hv.equalsIgnoreCase("V")) {
                        mTab.setValue("HORVER", (Object)hv);
                    } else {
                        mTab.setValue("HORVER", (Object)"");
                    }
                } else {
                    mTab.setValue("HORVER", (Object)"");
                }
                if (CombType.equalsIgnoreCase("S")) {
                    mTab.setValue("TYPE", (Object)"S");
                    mTab.setValue("SUPPLY", (Object)0);
                } else if (CombType.equalsIgnoreCase("C")) {
                    mTab.setValue("TYPE", (Object)"C");
                } else if (CombType.equalsIgnoreCase("O")) {
                    mTab.setValue("TYPE", (Object)"O");
                    mTab.setValue("SUPPLY", (Object)0);
                } else if (CombType.equalsIgnoreCase("T")) {
                    mTab.setValue("TYPE", (Object)"T");
                    mTab.setValue("SUPPLY", (Object)0);
                }
                if (WaysYN.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETWAYS", (Object)"Y");
                    mTab.setValue("WAYS", (Object)"4");
                } else {
                    mTab.setValue("SETWAYS", (Object)"N");
                }
                if (EQGridYN.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETEQGRID", (Object)"Y");
                    mTab.setValue("EQUGRIDYN", (Object)"Y");
                } else {
                    mTab.setValue("SETEQGRID", (Object)"N");
                    mTab.setValue("EQUGRIDYN", (Object)"N");
                }
                if (CornerYN.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETCORNER", (Object)"Y");
                } else {
                    mTab.setValue("SETCORNER", (Object)"N");
                    mTab.setValue("CORNERYN", (Object)"N");
                }
                if (CurveYN.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETCURVE", (Object)"Y");
                } else {
                    mTab.setValue("SETCURVE", (Object)"N");
                    mTab.setValue("CURVEYN", (Object)"N");
                }
                if (DeflectionYN.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETDEFLECTION", (Object)"Y");
                } else {
                    mTab.setValue("SETDEFLECTION", (Object)"N");
                    mTab.setValue("HORVER", null);
                    mTab.setValue("DEFLECTION", null);
                }
                if (IsSpcl.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETSPCLYN", (Object)"Y");
                } else {
                    mTab.setValue("SETSPCLYN", (Object)"N");
                }
                if (PrdVal.equalsIgnoreCase("AGVCDF")) {
                    mTab.setValue("VCD_NONSTD_YN", (Object)"Y");
                } else {
                    mTab.setValue("VCD_NONSTD_YN", (Object)"N");
                }
                mTab.setValue("INSSCRNYN", (Object)"N");
                if (NoParam.equalsIgnoreCase("Y")) {
                    mTab.setValue("ISNOPARAM", (Object)"Y");
                } else {
                    mTab.setValue("ISNOPARAM", (Object)"N");
                }
                if (ln.length() > 1) {
                    mTab.setValue("SETLENGTH", (Object)"Y");
                } else {
                    mTab.setValue("SETLENGTH", (Object)"N");
                }
                if (aw.length() > 1) {
                    mTab.setValue("SETAIRWAY", (Object)"Y");
                } else {
                    mTab.setValue("SETAIRWAY", (Object)"N");
                }
                if (od.equalsIgnoreCase("Y")) {
                    mTab.setValue("ISOD", (Object)"Y");
                    if (supplyhcell.length() > 1) {
                        mTab.setValue("ISODAPP", (Object)"Y");
                    } else {
                        mTab.setValue("ISODAPP", (Object)"N");
                    }
                } else {
                    mTab.setValue("ISOD", (Object)"N");
                    mTab.setValue("ISODAPP", (Object)"N");
                }
                if (alf.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETALFILTER", (Object)"Y");
                } else {
                    mTab.setValue("SETALFILTER", (Object)"N");
                }
                if (tBarYN.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETTBAR", (Object)"Y");
                } else {
                    mTab.setValue("SETTBAR", (Object)"N");
                }
                if (gNA.equalsIgnoreCase("A")) {
                    mTab.setValue("SETGNPARA", (Object)"N");
                } else {
                    mTab.setValue("SETGNPARA", (Object)"Y");
                }
                if (lvByArea.equalsIgnoreCase("N")) {
                    mTab.setValue("SETLVBYAREA", (Object)"N");
                } else {
                    mTab.setValue("SETLVBYAREA", (Object)"Y");
                }
                if (ulClass.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETULCLASS", (Object)"Y");
                } else {
                    mTab.setValue("SETULCLASS", (Object)"N");
                }
                if (IsVav.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETVAVYN", (Object)"Y");
                } else {
                    mTab.setValue("SETVAVYN", (Object)"N");
                }
                if (IsGasket.equalsIgnoreCase("Y")) {
                    mTab.setValue("SETGASKET", (Object)"Y");
                } else {
                    mTab.setValue("SETGASKET", (Object)"N");
                }
                if (PrdVal.equalsIgnoreCase("RLG16") | PrdVal.equalsIgnoreCase("RLRM16") | PrdVal.equalsIgnoreCase("RLRB16") | PrdVal.equalsIgnoreCase("RLRB16/RLG16") | PrdVal.equalsIgnoreCase("RLRM16/RLG16") | PrdVal.equalsIgnoreCase("SLG16") | PrdVal.equalsIgnoreCase("SLRM16") | PrdVal.equalsIgnoreCase("SLRB16") | PrdVal.equalsIgnoreCase("SLRB16/SLG16") | PrdVal.equalsIgnoreCase("SLRM16/SLG16") | PrdVal.equalsIgnoreCase("RLG12") | PrdVal.equalsIgnoreCase("RLRM12") | PrdVal.equalsIgnoreCase("RLRB12") | PrdVal.equalsIgnoreCase("RLRB12/RLG12") | PrdVal.equalsIgnoreCase("RLRM12/RLG12") | PrdVal.equalsIgnoreCase("SLG12") | PrdVal.equalsIgnoreCase("SLRM12") | PrdVal.equalsIgnoreCase("SLRB12") | PrdVal.equalsIgnoreCase("SLRB12/SLG12") | PrdVal.equalsIgnoreCase("SLRM12/SLG12") | PrdVal.equalsIgnoreCase("SLRB12-12.5/SLG12-12.5") | PrdVal.equalsIgnoreCase("SLRB12-20/SLG12-20") | PrdVal.equalsIgnoreCase("SLRB16-12.5/SLG16-12.5") | PrdVal.equalsIgnoreCase("SLRB16-20/SLG16-20") | PrdVal.equalsIgnoreCase("SLRM12-12.5/SLG12-12.5") | PrdVal.equalsIgnoreCase("SLRM12-20/SLG12-20") | PrdVal.equalsIgnoreCase("SLRM16-12.5/SLG16-12.5") | PrdVal.equalsIgnoreCase("SLRM16-20/SLG16-20") | PrdVal.equalsIgnoreCase("RLRB12-20/RLG12-20") | PrdVal.equalsIgnoreCase("RLRB16-20/RLG16-20") | PrdVal.equalsIgnoreCase("RLRM12-20/RLG12-20") | PrdVal.equalsIgnoreCase("RLRM16-20/RLG16-20") | PrdVal.equalsIgnoreCase("RLG12-20") | PrdVal.equalsIgnoreCase("RLG16-20") | PrdVal.equalsIgnoreCase("SLG12-12.5") | PrdVal.equalsIgnoreCase("SLG12-20") | PrdVal.equalsIgnoreCase("SLG16-12.5") | PrdVal.equalsIgnoreCase("SLG16-20") | PrdVal.equalsIgnoreCase("RLRB12-20") | PrdVal.equalsIgnoreCase("RLRB16-20") | PrdVal.equalsIgnoreCase("RLRM12-20") | PrdVal.equalsIgnoreCase("RLRM16-20") | PrdVal.equalsIgnoreCase("SLRB12-12.5") | PrdVal.equalsIgnoreCase("SLRB12-20") | PrdVal.equalsIgnoreCase("SLRB16-12.5") | PrdVal.equalsIgnoreCase("SLRB16-20") | PrdVal.equalsIgnoreCase("SLRM12-12.5") | PrdVal.equalsIgnoreCase("SLRM12-20") | PrdVal.equalsIgnoreCase("SLRM16-12.5") | PrdVal.equalsIgnoreCase("SLRM16-20") | PrdVal.equalsIgnoreCase("JZ-RLG16-S") | PrdVal.equalsIgnoreCase("JZ-RLG16-D") | PrdVal.equalsIgnoreCase("RLG12-12.5") | PrdVal.equalsIgnoreCase("RLG16-12.5") | PrdVal.equalsIgnoreCase("RLRB12-12.5") | PrdVal.equalsIgnoreCase("RLRB16-12.5") | PrdVal.equalsIgnoreCase("RLRM12-12.5") | PrdVal.equalsIgnoreCase("RLRM16-12.5") | PrdVal.equalsIgnoreCase("RLRB12-12.5/RLG12-12.5") | PrdVal.equalsIgnoreCase("RLRM12-12.5/RLG12-12.5") | PrdVal.equalsIgnoreCase("RLRB16-12.5/RLG16-12.5") | PrdVal.equalsIgnoreCase("RLRM16-12.5/RLG16-12.5")) {
                    String unit = mTab.get_ValueAsString("UNIT");
                    if (unit.equalsIgnoreCase("N")) {
                        mTab.setValue("SETBUNIT", (Object)"Y");
                        mTab.setValue("BUNIT", (Object)"M");
                    }
                } else {
                    mTab.setValue("SETBUNIT", (Object)"N");
                }
                if (PrdVal.equalsIgnoreCase("AUVCDF") | PrdVal.equalsIgnoreCase("AUVCDB") | PrdVal.equalsIgnoreCase("AUVCDH") | PrdVal.equalsIgnoreCase("AUVCDS") | PrdVal.equalsIgnoreCase("AGVCDF") | PrdVal.equalsIgnoreCase("AGVCDB") | PrdVal.equalsIgnoreCase("AGVCDS") | PrdVal.equalsIgnoreCase("LVCDF") | PrdVal.equalsIgnoreCase("LVCDH") | PrdVal.equalsIgnoreCase("3VCDF") | PrdVal.equalsIgnoreCase("3VCDB") | PrdVal.equalsIgnoreCase("3VCDH") | PrdVal.equalsIgnoreCase("3VCDS") | PrdVal.equalsIgnoreCase("VDR") | PrdVal.equalsIgnoreCase("PI3VCD") | PrdVal.equalsIgnoreCase("PIAVCD")) {
                    mTab.setValue("SETDRIVEYN", (Object)"Y");
                } else {
                    mTab.setValue("SETDRIVEYN", (Object)"N");
                }
                if (PrdVal.equalsIgnoreCase("VDR")) {
                    mTab.setValue("MECHANISM_VDR", (Object)"L");
                }
                if (Bom.trim().contentEquals("N")) {
                    BigDecimal sprice = new BigDecimal(rmcost.doubleValue() * pf.doubleValue());
                    if (sprice.doubleValue() != 0.0) {
                        sprice = sprice.setScale(2, 4);
                        BigDecimal disc_pcnt = (BigDecimal)mTab.getValue("DISC_PCNT");
                        BigDecimal pcnt = new BigDecimal(100).subtract(disc_pcnt).divide(new BigDecimal(100));
                        BigDecimal netprice = sprice.multiply(pcnt);
                        netprice = netprice.setScale(10, 4);
                        mTab.setValue("price", (Object)sprice);
                        mTab.setValue("NETPRICE", (Object)netprice);
                        if ((Integer)mTab.getValue("Qty") != null) {
                            BigDecimal Qty = (BigDecimal)mTab.getValue("Qty");
                            BigDecimal Totalline = Qty.multiply(netprice);
                            Totalline = Totalline.setScale(10, 4);
                            mTab.setValue("TOTALLINE", (Object)Totalline);
                        }
                    } else {
                        mTab.setValue("price", (Object)Env.ZERO);
                        mTab.setValue("NETPRICE", (Object)Env.ZERO);
                        mTab.setValue("TOTALLINE", (Object)Env.ZERO);
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return "";
            }
            catch (Exception e) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return "";
    }

    public String SetBUnit(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if ((Integer)mTab.getValue("M_Product_ID") != null) {
            Integer ProdId = (Integer)mTab.getValue("M_Product_ID");
            String SqlProd = "Select value from m_product where m_product_id = ?";
            String PrdVal = DB.getSQLValueString(null, (String)SqlProd, (int)ProdId);
            String unit = mTab.get_ValueAsString("UNIT");
            if (PrdVal.equalsIgnoreCase("RLG16") | PrdVal.equalsIgnoreCase("RLRM16") | PrdVal.equalsIgnoreCase("RLRB16") | PrdVal.equalsIgnoreCase("RLRB16/RLG16") | PrdVal.equalsIgnoreCase("RLRM16/RLG16") | PrdVal.equalsIgnoreCase("SLG16") | PrdVal.equalsIgnoreCase("SLRM16") | PrdVal.equalsIgnoreCase("SLRB16") | PrdVal.equalsIgnoreCase("SLRB16/SLG16") | PrdVal.equalsIgnoreCase("SLRM16/SLG16") | PrdVal.equalsIgnoreCase("RLG12") | PrdVal.equalsIgnoreCase("RLRM12") | PrdVal.equalsIgnoreCase("RLRB12") | PrdVal.equalsIgnoreCase("RLRB12/RLG12") | PrdVal.equalsIgnoreCase("RLRM12/RLG12") | PrdVal.equalsIgnoreCase("SLG12") | PrdVal.equalsIgnoreCase("SLRM12") | PrdVal.equalsIgnoreCase("SLRB12") | PrdVal.equalsIgnoreCase("SLRB12/SLG12") | PrdVal.equalsIgnoreCase("SLRM12/SLG12") | PrdVal.equalsIgnoreCase("SLRB12-12.5/SLG12-12.5") | PrdVal.equalsIgnoreCase("SLRB12-20/SLG12-20") | PrdVal.equalsIgnoreCase("SLRB16-12.5/SLG16-12.5") | PrdVal.equalsIgnoreCase("SLRB16-20/SLG16-20") | PrdVal.equalsIgnoreCase("SLRM12-12.5/SLG12-12.5") | PrdVal.equalsIgnoreCase("SLRM12-20/SLG12-20") | PrdVal.equalsIgnoreCase("SLRM16-12.5/SLG16-12.5") | PrdVal.equalsIgnoreCase("SLRM16-20/SLG16-20") | PrdVal.equalsIgnoreCase("RLRB12-20/RLG12-20") | PrdVal.equalsIgnoreCase("RLRB16-20/RLG16-20") | PrdVal.equalsIgnoreCase("RLRM12-20/RLG12-20") | PrdVal.equalsIgnoreCase("RLRM16-20/RLG16-20") | PrdVal.equalsIgnoreCase("RLG12-20") | PrdVal.equalsIgnoreCase("RLG16-20") | PrdVal.equalsIgnoreCase("SLG12-12.5") | PrdVal.equalsIgnoreCase("SLG12-20") | PrdVal.equalsIgnoreCase("SLG16-12.5") | PrdVal.equalsIgnoreCase("SLG16-20") | PrdVal.equalsIgnoreCase("RLRB12-20") | PrdVal.equalsIgnoreCase("RLRB16-20") | PrdVal.equalsIgnoreCase("RLRM12-20") | PrdVal.equalsIgnoreCase("RLRM16-20") | PrdVal.equalsIgnoreCase("SLRB12-12.5") | PrdVal.equalsIgnoreCase("SLRB12-20") | PrdVal.equalsIgnoreCase("SLRB16-12.5") | PrdVal.equalsIgnoreCase("SLRB16-20") | PrdVal.equalsIgnoreCase("SLRM12-12.5") | PrdVal.equalsIgnoreCase("SLRM12-20") | PrdVal.equalsIgnoreCase("SLRM16-12.5") | PrdVal.equalsIgnoreCase("SLRM16-20") | PrdVal.equalsIgnoreCase("JZ-RLG16-S") | PrdVal.equalsIgnoreCase("JZ-RLG16-D") | PrdVal.equalsIgnoreCase("RLG12-12.5") | PrdVal.equalsIgnoreCase("RLG16-12.5") | PrdVal.equalsIgnoreCase("RLRB12-12.5") | PrdVal.equalsIgnoreCase("RLRB16-12.5") | PrdVal.equalsIgnoreCase("RLRM12-12.5") | PrdVal.equalsIgnoreCase("RLRM16-12.5") | PrdVal.equalsIgnoreCase("RLRB12-12.5/RLG12-12.5") | PrdVal.equalsIgnoreCase("RLRM12-12.5/RLG12-12.5") | PrdVal.equalsIgnoreCase("RLRB16-12.5/RLG16-12.5") | PrdVal.equalsIgnoreCase("RLRM16-12.5/RLG16-12.5") && unit.equalsIgnoreCase("N")) {
                mTab.setValue("SETBUNIT", (Object)"Y");
                mTab.setValue("BUNIT", (Object)"M");
                return "";
            }
        }
        mTab.setValue("SETBUNIT", (Object)"N");
        return "";
    }

    public String GetPrjName(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer ProjId;
        if ((Integer)mTab.getValue("Beta_Cust_Project_ID") != null && (ProjId = (Integer)mTab.getValue("Beta_Cust_Project_ID")).doubleValue() != 1000393.0) {
            String SqlProj = "Select Name from Beta_Cust_Project where Beta_Cust_Project_id = ?";
            String PrjName = DB.getSQLValueString(null, (String)SqlProj, (int)ProjId);
            mTab.setValue("PROJECT", (Object)PrjName);
        }
        return "";
    }

    public String SetBforLV(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        try {
            Boolean lv = (Boolean)mTab.getValue("LVBYAREAYN");
            if (lv.booleanValue()) {
                mTab.setValue("B", (Object)new BigDecimal(1000));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String SetActuator(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String driveVal = mTab.get_ValueAsString("DRIVE");
        if (driveVal.equalsIgnoreCase("Q")) {
            mTab.setValue("Beta_Qtn_Actuator_ID", null);
        }
        return "";
    }

    public String SetBforSILAX(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal lnValue = Env.ZERO;
        Integer ProdId = (Integer)mTab.getValue("M_Product_ID");
        if (ProdId == null) {
            return "";
        }
        String SqlProd = "Select value from m_product where m_product_id = ?";
        String PrdVal = DB.getSQLValueString(null, (String)SqlProd, (int)ProdId);
        if (PrdVal.equalsIgnoreCase("SILAX") | PrdVal.equalsIgnoreCase("SILAX-P")) {
            String lnDia = (String)mTab.getValue("SILAXLENDIA");
            BigDecimal aVal = (BigDecimal)mTab.getValue("A");
            if (lnDia == null) {
                return "";
            }
            if (lnDia.equalsIgnoreCase("1D")) {
                lnValue = new BigDecimal(1);
            } else if (lnDia.equalsIgnoreCase("1.5D")) {
                lnValue = new BigDecimal(1.5);
            } else if (lnDia.equalsIgnoreCase("2D")) {
                lnValue = new BigDecimal(2);
            }
            if (aVal.doubleValue() != 0.0 && lnValue.doubleValue() != 0.0) {
                if (aVal.doubleValue() == 315.0 && lnValue.doubleValue() == 1.5) {
                    mTab.setValue("B", (Object)new BigDecimal(475));
                } else {
                    mTab.setValue("B", (Object)new BigDecimal(aVal.doubleValue() * lnValue.doubleValue()));
                }
            }
        }
        return "";
    }

    public String SetABValue(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal abValue = Env.ZERO;
        if ((Integer)mTab.getValue("M_Product_ID") != null) {
            String ul_spigotyn;
            Integer ProdId = (Integer)mTab.getValue("M_Product_ID");
            String SqlProd = "Select value from m_product where m_product_id = ?";
            String PrdVal = DB.getSQLValueString(null, (String)SqlProd, (int)ProdId);
            BigDecimal neckDia = (BigDecimal)mTab.getValue("NECKDIA");
            String unit = mTab.get_ValueAsString("UNIT");
            if (PrdVal.equalsIgnoreCase("BMSD/R") | PrdVal.equalsIgnoreCase("BMFSD/R-T") | PrdVal.equalsIgnoreCase("BEMFSD/R-T") | PrdVal.equalsIgnoreCase("BMFD/R-T") | PrdVal.equalsIgnoreCase("BEMFD/R-T") | PrdVal.equalsIgnoreCase("BFD/R-F") | PrdVal.equalsIgnoreCase("BEFD/R-F") | PrdVal.equalsIgnoreCase("BMFD/R-F") | PrdVal.equalsIgnoreCase("BEMFD/R-F") | PrdVal.equalsIgnoreCase("BMFD/R-TF") | PrdVal.equalsIgnoreCase("BEMFD/R-TF")) {
                if (neckDia.doubleValue() == 0.0) {
                    mTab.fireDataStatusEEvent(" Diameter ", "Neck Diameter should not be zero", true);
                    abValue = Env.ZERO;
                } else if (unit.equalsIgnoreCase("I")) {
                    abValue = new BigDecimal(neckDia.doubleValue() + 4.0);
                } else if (unit.equalsIgnoreCase("M")) {
                    abValue = new BigDecimal(Math.round(neckDia.doubleValue() * 25.4) + 102L);
                }
                mTab.setValue("A", (Object)abValue);
                mTab.setValue("B", (Object)abValue);
            } else if (PrdVal.equalsIgnoreCase("BMFSD-NEW") | PrdVal.equalsIgnoreCase("BEMFSD-NEW") | PrdVal.equalsIgnoreCase("BMSD-NEW") | PrdVal.equalsIgnoreCase("BEMFD-NEW") | PrdVal.equalsIgnoreCase("BMFD-NEW") && (ul_spigotyn = mTab.get_ValueAsString("UL_SPIGOT")).equalsIgnoreCase("Y")) {
                if (neckDia.doubleValue() == 0.0) {
                    mTab.fireDataStatusEEvent(" Diameter ", "Neck Diameter should not be zero", true);
                    abValue = Env.ZERO;
                } else if (unit.equalsIgnoreCase("I")) {
                    abValue = new BigDecimal(neckDia.doubleValue() + 4.0);
                } else if (unit.equalsIgnoreCase("M")) {
                    abValue = new BigDecimal(Math.round(neckDia.doubleValue() * 25.4) + 102L);
                }
                mTab.setValue("A", (Object)abValue);
                mTab.setValue("B", (Object)abValue);
            }
        }
        return "";
    }

    public String PcType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql = null;
        Integer RowNo = null;
        String pcValue = (String)mTab.getValue("POWDERCOATTYPE");
        sql = "SELECT AD_REF_LIST.NAME PCNAME FROM AD_REF_LIST WHERE AD_REF_LIST.AD_REFERENCE_ID IN (SELECT AD_REFERENCE.AD_REFERENCE_ID FROM AD_REFERENCE WHERE AD_REFERENCE.NAME LIKE 'Beta_Qtn_PCType') AND AD_REF_LIST.VALUE =?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setString(1, pcValue);
            rs = pstmt.executeQuery();
            rs.next();
            RowNo = rs.getRow();
            if (RowNo == 0) {
                mTab.setValue("FINISHDESC1", (Object)"");
            } else {
                mTab.setValue("FINISHDESC1", (Object)rs.getString("PCNAME"));
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return "";
        }
        catch (Exception e) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return "";
        }
    }

    public String SetSlotNo(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal Avalue = (BigDecimal)mTab.getValue("SLOTNO");
        mTab.setValue("A", (Object)Avalue);
        return "";
    }

    public String SetNeckDia(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal Lvalue = (BigDecimal)mTab.getValue("NECKDIA");
        mTab.setValue("LENGTH", (Object)Lvalue);
        return "";
    }

    public String SetDoor(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql = null;
        Integer RowNo = null;
        if ((Integer)mTab.getValue("C_ProjectType_ID") != null) {
            sql = "Select C_ProjectType_ID from C_ProjectType where Name Like 'Doors%' and C_ProjectType_ID =?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, (Integer)mTab.getValue("C_ProjectType_ID"));
                rs = pstmt.executeQuery();
                rs.next();
                RowNo = rs.getRow();
                if (RowNo == 0) {
                    mTab.setValue("ISDOOR", (Object)"N");
                } else {
                    mTab.setValue("ISDOOR", (Object)"Y");
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return "";
            }
            catch (Exception e) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return "";
    }

    public String SetQtyML(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double MLQty = new Double("" + (BigDecimal)mTab.getValue("ML"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = MLQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyPP(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double PPQty = new Double("" + (BigDecimal)mTab.getValue("PP"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = PPQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyDL(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double DLQty = new Double("" + (BigDecimal)mTab.getValue("DL"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = DLQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyI(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double IQty = new Double("" + (BigDecimal)mTab.getValue("I"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = IQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyPD(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double PDQty = new Double("" + (BigDecimal)mTab.getValue("PD"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = PDQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyPV(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double PVQty = new Double("" + (BigDecimal)mTab.getValue("PV"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = PVQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyH(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double HQty = new Double("" + (BigDecimal)mTab.getValue("H"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = HQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyFB(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double FBQty = new Double("" + (BigDecimal)mTab.getValue("FB"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = FBQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyCL(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double CLQty = new Double("" + (BigDecimal)mTab.getValue("CL"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = CLQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyST(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double STQty = new Double("" + (BigDecimal)mTab.getValue("ST"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = STQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtySL(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double SLQty = new Double("" + (BigDecimal)mTab.getValue("SL"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = SLQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }

    public String SetQtyAB(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Double ABQty = new Double("" + (BigDecimal)mTab.getValue("AB"));
        Double SetQty = new Double("" + (BigDecimal)mTab.getValue("PQTY"));
        Double NetPrice = new Double("" + (BigDecimal)mTab.getValue("NETPRICE"));
        Double Qty = ABQty * SetQty;
        Double Amt = Qty * NetPrice;
        mTab.setValue("QTY", (Object)Qty);
        mTab.setValue("TOTALLINE", (Object)Amt);
        return "";
    }
}

