/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.SelectActuator;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class SelectActuatorActuator
extends SelectActuator {
    public int volt = 230;
    public String PrdVal = "";
    public String OnOffMod = "O";
    public char fswitch = (char)70;
    public char narea = (char)70;
    public char fspring = (char)70;
    public float areav;
    public BigDecimal actqty = Env.ZERO;
    Vector<Vector<Object>> data = new Vector();

    public SelectActuatorActuator(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_QUOTATIONLINE_ID", (boolean)false)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"SelectActuator"));
        return true;
    }

    public static float round(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Float.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd.floatValue();
    }

    protected Vector<Vector<Object>> getActuatorData() {
        Vector data2;
        block39: {
            String vbrand;
            Float varea;
            Vector<Object> line;
            ResultSet rs2;
            CPreparedStatement pstmt2;
            StringBuffer sql2;
            data2 = new Vector();
            data2.removeAllElements();
            if (this.narea == 'T') {
                sql2 = new StringBuffer("SELECT distinct(area),brand from Beta_qtn_actuator where    isActive ='Y' and\tvolt=?  and OnOffMod=?  ");
                if (this.fswitch == 'T') {
                    sql2.append(" and AUXSWITCHYN='Y'");
                } else {
                    sql2.append(" and AUXSWITCHYN='N'");
                }
                if (this.fspring == 'T') {
                    sql2.append(" and SPRINGRETYN='Y'");
                } else if (this.PrdVal.equalsIgnoreCase("MPRD")) {
                    sql2.append(" and SPRINGRETYN='Y'");
                } else {
                    sql2.append(" and SPRINGRETYN='N'");
                }
                sql2.append(" order by brand");
                pstmt2 = null;
                rs2 = null;
                try {
                    try {
                        pstmt2 = DB.prepareStatement((String)sql2.toString(), null);
                        pstmt2.setInt(1, this.volt);
                        pstmt2.setString(2, this.OnOffMod);
                        rs2 = pstmt2.executeQuery();
                        while (rs2.next()) {
                            line = new Vector<Object>(2);
                            varea = Float.valueOf(rs2.getFloat(1));
                            varea = Float.valueOf(SelectActuatorActuator.round(varea.floatValue(), 2));
                            vbrand = rs2.getString("brand");
                            line.add(varea);
                            line.add(vbrand);
                            data2.add(line);
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql2.toString(), (Throwable)e);
                        DB.close(rs2, (Statement)pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs2, (Statement)pstmt2);
                rs2 = null;
                pstmt2 = null;
            } else {
                sql2 = new StringBuffer("SELECT min(area),brand from Beta_qtn_actuator where    isActive ='Y' and\tvolt=?  and OnOffMod=? and area>=? ");
                if (this.fswitch == 'T') {
                    sql2.append(" and AUXSWITCHYN='Y'");
                } else {
                    sql2.append(" and AUXSWITCHYN='N'");
                }
                if (this.fspring == 'T') {
                    sql2.append(" and SPRINGRETYN='Y'");
                } else if (this.PrdVal.equalsIgnoreCase("MPRD")) {
                    sql2.append(" and SPRINGRETYN='Y'");
                } else {
                    sql2.append(" and SPRINGRETYN='N'");
                }
                sql2.append(" group by brand order by brand");
                pstmt2 = null;
                rs2 = null;
                try {
                    try {
                        pstmt2 = DB.prepareStatement((String)sql2.toString(), null);
                        pstmt2.setInt(1, this.volt);
                        pstmt2.setString(2, this.OnOffMod);
                        pstmt2.setFloat(3, this.areav);
                        rs2 = pstmt2.executeQuery();
                        while (rs2.next()) {
                            line = new Vector(2);
                            varea = Float.valueOf(rs2.getFloat(1));
                            varea = Float.valueOf(SelectActuatorActuator.round(varea.floatValue(), 2));
                            vbrand = rs2.getString("brand");
                            line.add(varea);
                            line.add(vbrand);
                            data2.add(line);
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql2.toString(), (Throwable)e);
                        DB.close(rs2, (Statement)pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs2, (Statement)pstmt2);
                rs2 = null;
                pstmt2 = null;
            }
        }
        this.data.removeAllElements();
        int i = 0;
        while (i < data2.size()) {
            block42: {
                StringBuffer sql = new StringBuffer("SELECT Beta_qtn_actuator_ID,name, nm,runningtime,exclbpvavyn,springretyn from Beta_qtn_actuator where   isActive ='Y' and volt=?  and OnOffMod=? and area=? and brand=?");
                if (this.fswitch == 'T') {
                    sql.append(" and AUXSWITCHYN='Y'");
                } else {
                    sql.append(" and AUXSWITCHYN='N'");
                }
                if (this.fspring == 'T') {
                    sql.append(" and SPRINGRETYN='Y'");
                } else if (this.PrdVal.equalsIgnoreCase("MPRD")) {
                    sql.append(" and SPRINGRETYN='Y'");
                } else {
                    sql.append(" and SPRINGRETYN='N'");
                }
                sql.append(" order by name");
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), null);
                        pstmt.setInt(1, this.volt);
                        pstmt.setString(2, this.OnOffMod);
                        pstmt.setFloat(3, ((Float)((Vector)data2.get(i)).get(0)).floatValue());
                        pstmt.setString(4, (String)((Vector)data2.get(i)).get(1));
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Vector<Object> line = new Vector<Object>(3);
                            KeyNamePair pp = new KeyNamePair(rs.getInt("Beta_qtn_actuator_ID"), rs.getString("name").trim());
                            String nm = rs.getString("nm");
                            String trime = rs.getString("runningtime");
                            line.add(new Boolean(false));
                            line.add(pp);
                            line.add(nm);
                            line.add(trime);
                            String vavyn = rs.getString("exclbpvavyn");
                            String spret = rs.getString("springretyn");
                            if (this.PrdVal.equalsIgnoreCase("EBP1") | this.PrdVal.equalsIgnoreCase("EBP2") | this.PrdVal.equalsIgnoreCase("EBP3") | this.PrdVal.equalsIgnoreCase("EBP4") | this.PrdVal.equalsIgnoreCase("EBP5") | this.PrdVal.equalsIgnoreCase("EBP6") | this.PrdVal.equalsIgnoreCase("EBP7") | this.PrdVal.equalsIgnoreCase("EBP8") | this.PrdVal.equalsIgnoreCase("SDVBP") | this.PrdVal.equalsIgnoreCase("SDVBPE")) {
                                if (vavyn.equalsIgnoreCase("Y")) continue;
                                this.data.add(line);
                                continue;
                            }
                            if (this.PrdVal.equalsIgnoreCase("MPRD")) {
                                if (!spret.equalsIgnoreCase("Y")) continue;
                                this.data.add(line);
                                continue;
                            }
                            this.data.add(line);
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            ++i;
        }
        return this.data;
    }

    public void info() {
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add("Select");
        columnNames.add(" Name      ");
        columnNames.add("Nm   ");
        columnNames.add("Running Time ");
        return columnNames;
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, String.class, false);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnReadOnly(1, true);
        miniTable.setColumnReadOnly(2, true);
        miniTable.setColumnReadOnly(3, true);
        miniTable.autoSize();
    }

    public boolean save(IMiniTable miniTable, String trxName) {
        int C_QUOTATIONLINE_ID = (Integer)this.getGridTab().getValue("C_QUOTATIONLINE_ID");
        int count = 0;
        int i = 0;
        while (i < this.data.size()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            return false;
        }
        i = 0;
        while (i < this.data.size()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                int n;
                CPreparedStatement ps;
                String updateQuery;
                KeyNamePair pp = (KeyNamePair)this.data.get(i).get(1);
                int actuator_id = pp.getKey();
                try {
                    updateQuery = "UPDATE C_QUOTATIONLINE set Beta_qtn_actuator_ID =? where C_QUOTATIONLINE_ID=?";
                    ps = DB.prepareStatement((String)updateQuery);
                    ps.setInt(1, actuator_id);
                    ps.setInt(2, C_QUOTATIONLINE_ID);
                    n = ps.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                try {
                    updateQuery = "UPDATE C_QUOTATIONLINE set actQty =? where C_QUOTATIONLINE_ID=?";
                    ps = DB.prepareStatement((String)updateQuery);
                    ps.setBigDecimal(1, this.actqty);
                    ps.setInt(2, C_QUOTATIONLINE_ID);
                    n = ps.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return true;
    }
}

